package zio.aws.globalaccelerator
import zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.globalaccelerator.model.{
  DescribeCustomRoutingEndpointGroupRequest,
  UpdateAcceleratorRequest,
  AllowCustomRoutingTrafficRequest,
  DescribeAcceleratorRequest,
  ListCustomRoutingEndpointGroupsRequest,
  DescribeCustomRoutingAcceleratorAttributesRequest,
  ListListenersRequest,
  DescribeListenerRequest,
  DeleteAcceleratorRequest,
  ListAcceleratorsRequest,
  ListCustomRoutingPortMappingsRequest,
  CreateAcceleratorRequest,
  DeleteCustomRoutingEndpointGroupRequest,
  DescribeAcceleratorAttributesRequest,
  CreateCustomRoutingListenerRequest,
  ListCustomRoutingAcceleratorsRequest,
  UpdateAcceleratorAttributesRequest,
  DescribeCustomRoutingAcceleratorRequest,
  ListTagsForResourceRequest,
  UpdateCustomRoutingAcceleratorRequest,
  CreateCustomRoutingEndpointGroupRequest,
  DenyCustomRoutingTrafficRequest,
  ListCustomRoutingPortMappingsByDestinationRequest,
  ListEndpointGroupsRequest,
  UpdateEndpointGroupRequest,
  UpdateListenerRequest,
  ListByoipCidrsRequest,
  ProvisionByoipCidrRequest,
  AdvertiseByoipCidrRequest,
  DeprovisionByoipCidrRequest,
  UpdateCustomRoutingAcceleratorAttributesRequest,
  UntagResourceRequest,
  DeleteEndpointGroupRequest,
  AddCustomRoutingEndpointsRequest,
  DeleteCustomRoutingListenerRequest,
  RemoveCustomRoutingEndpointsRequest,
  UpdateCustomRoutingListenerRequest,
  CreateEndpointGroupRequest,
  CreateCustomRoutingAcceleratorRequest,
  DeleteListenerRequest,
  CreateListenerRequest,
  DescribeEndpointGroupRequest,
  ListCustomRoutingListenersRequest,
  DescribeCustomRoutingListenerRequest,
  TagResourceRequest,
  DeleteCustomRoutingAcceleratorRequest,
  WithdrawByoipCidrRequest
}
import software.amazon.awssdk.services.globalaccelerator.model.{
  DescribeListenerResponse,
  DeleteCustomRoutingEndpointGroupResponse,
  WithdrawByoipCidrResponse,
  EndpointGroup,
  DeleteCustomRoutingListenerResponse,
  DescribeCustomRoutingAcceleratorAttributesResponse,
  ListEndpointGroupsResponse,
  CreateCustomRoutingAcceleratorResponse,
  ByoipCidr,
  DeleteEndpointGroupResponse,
  ListListenersResponse,
  CreateAcceleratorResponse,
  ProvisionByoipCidrResponse,
  ListCustomRoutingEndpointGroupsResponse,
  CreateCustomRoutingEndpointGroupResponse,
  ListCustomRoutingAcceleratorsResponse,
  DescribeCustomRoutingListenerResponse,
  CreateEndpointGroupResponse,
  UpdateCustomRoutingAcceleratorAttributesResponse,
  Accelerator,
  UpdateAcceleratorAttributesResponse,
  ListTagsForResourceResponse,
  UpdateCustomRoutingListenerResponse,
  DenyCustomRoutingTrafficResponse,
  UntagResourceResponse,
  Listener,
  UpdateCustomRoutingAcceleratorResponse,
  AllowCustomRoutingTrafficResponse,
  CreateCustomRoutingListenerResponse,
  DeleteAcceleratorResponse,
  CustomRoutingEndpointGroup,
  DescribeCustomRoutingEndpointGroupResponse,
  ListCustomRoutingListenersResponse,
  DeleteCustomRoutingAcceleratorResponse,
  ListCustomRoutingPortMappingsByDestinationResponse,
  AddCustomRoutingEndpointsResponse,
  CustomRoutingListener,
  ListByoipCidrsResponse,
  DeleteListenerResponse,
  AdvertiseByoipCidrResponse,
  UpdateAcceleratorResponse,
  RemoveCustomRoutingEndpointsResponse,
  CreateListenerResponse,
  DescribeCustomRoutingAcceleratorResponse,
  ListCustomRoutingPortMappingsResponse,
  DescribeAcceleratorResponse,
  CustomRoutingAccelerator,
  UpdateEndpointGroupResponse,
  DescribeAcceleratorAttributesResponse,
  ListAcceleratorsResponse,
  TagResourceResponse,
  DescribeEndpointGroupResponse,
  PortMapping,
  DeprovisionByoipCidrResponse,
  UpdateListenerResponse,
  DestinationPortMapping
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.globalaccelerator.{
  GlobalAcceleratorAsyncClientBuilder,
  GlobalAcceleratorAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait GlobalAccelerator extends AspectSupport[GlobalAccelerator] {
  val api: GlobalAcceleratorAsyncClient
  def updateAcceleratorAttributes(
      request: UpdateAcceleratorAttributesRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly
  ]
  def deleteEndpointGroup(
      request: DeleteEndpointGroupRequest
  ): IO[AwsError, Unit]
  def listCustomRoutingPortMappings(
      request: ListCustomRoutingPortMappingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.globalaccelerator.model.PortMapping.ReadOnly
  ]
  def listCustomRoutingPortMappingsPaginated(
      request: ListCustomRoutingPortMappingsRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly
  ]
  def createEndpointGroup(request: CreateEndpointGroupRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly
  ]
  def createCustomRoutingListener(
      request: CreateCustomRoutingListenerRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.CreateCustomRoutingListenerResponse.ReadOnly
  ]
  def updateCustomRoutingAcceleratorAttributes(
      request: UpdateCustomRoutingAcceleratorAttributesRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly
  ]
  def updateCustomRoutingAccelerator(
      request: UpdateCustomRoutingAcceleratorRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly
  ]
  def describeAcceleratorAttributes(
      request: DescribeAcceleratorAttributesRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly
  ]
  def describeEndpointGroup(request: DescribeEndpointGroupRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly
  ]
  def listEndpointGroups(request: ListEndpointGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
  ]
  def listEndpointGroupsPaginated(request: ListEndpointGroupsRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly
  ]
  def listCustomRoutingAccelerators(
      request: ListCustomRoutingAcceleratorsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
  ]
  def listCustomRoutingAcceleratorsPaginated(
      request: ListCustomRoutingAcceleratorsRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly
  ]
  def createAccelerator(request: CreateAcceleratorRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly
  ]
  def deleteCustomRoutingEndpointGroup(
      request: DeleteCustomRoutingEndpointGroupRequest
  ): IO[AwsError, Unit]
  def deleteListener(request: DeleteListenerRequest): IO[AwsError, Unit]
  def deleteCustomRoutingListener(
      request: DeleteCustomRoutingListenerRequest
  ): IO[AwsError, Unit]
  def updateEndpointGroup(request: UpdateEndpointGroupRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly
  ]
  def deprovisionByoipCidr(request: DeprovisionByoipCidrRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DeprovisionByoipCidrResponse.ReadOnly
  ]
  def describeListener(request: DescribeListenerRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly
  ]
  def deleteAccelerator(request: DeleteAcceleratorRequest): IO[AwsError, Unit]
  def addCustomRoutingEndpoints(request: AddCustomRoutingEndpointsRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly
  ]
  def listCustomRoutingEndpointGroups(
      request: ListCustomRoutingEndpointGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
  ]
  def listCustomRoutingEndpointGroupsPaginated(
      request: ListCustomRoutingEndpointGroupsRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly
  ]
  def listByoipCidrs(
      request: ListByoipCidrsRequest
  ): ZStream[Any, AwsError, zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly]
  def listByoipCidrsPaginated(request: ListByoipCidrsRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly
  ]
  def updateCustomRoutingListener(
      request: UpdateCustomRoutingListenerRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly
  ]
  def createCustomRoutingAccelerator(
      request: CreateCustomRoutingAcceleratorRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse.ReadOnly
  ]
  def describeCustomRoutingEndpointGroup(
      request: DescribeCustomRoutingEndpointGroupRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse.ReadOnly
  ]
  def createListener(request: CreateListenerRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.CreateListenerResponse.ReadOnly
  ]
  def describeCustomRoutingListener(
      request: DescribeCustomRoutingListenerRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly
  ]
  def allowCustomRoutingTraffic(
      request: AllowCustomRoutingTrafficRequest
  ): IO[AwsError, Unit]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UntagResourceResponse.ReadOnly
  ]
  def removeCustomRoutingEndpoints(
      request: RemoveCustomRoutingEndpointsRequest
  ): IO[AwsError, Unit]
  def describeCustomRoutingAcceleratorAttributes(
      request: DescribeCustomRoutingAcceleratorAttributesRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse.ReadOnly
  ]
  def describeCustomRoutingAccelerator(
      request: DescribeCustomRoutingAcceleratorRequest
  ): IO[AwsError, ReadOnly]
  def listCustomRoutingPortMappingsByDestination(
      request: ListCustomRoutingPortMappingsByDestinationRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly
  ]
  def listCustomRoutingPortMappingsByDestinationPaginated(
      request: ListCustomRoutingPortMappingsByDestinationRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly
  ]
  def withdrawByoipCidr(request: WithdrawByoipCidrRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listAccelerators(request: ListAcceleratorsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.globalaccelerator.model.Accelerator.ReadOnly
  ]
  def listAcceleratorsPaginated(request: ListAcceleratorsRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly
  ]
  def advertiseByoipCidr(request: AdvertiseByoipCidrRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.globalaccelerator.model.TagResourceResponse.ReadOnly]
  def updateListener(request: UpdateListenerRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly
  ]
  def updateAccelerator(request: UpdateAcceleratorRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly
  ]
  def createCustomRoutingEndpointGroup(
      request: CreateCustomRoutingEndpointGroupRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly
  ]
  def denyCustomRoutingTraffic(
      request: DenyCustomRoutingTrafficRequest
  ): IO[AwsError, Unit]
  def deleteCustomRoutingAccelerator(
      request: DeleteCustomRoutingAcceleratorRequest
  ): IO[AwsError, Unit]
  def listListeners(
      request: ListListenersRequest
  ): ZStream[Any, AwsError, zio.aws.globalaccelerator.model.Listener.ReadOnly]
  def listListenersPaginated(request: ListListenersRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly
  ]
  def describeAccelerator(request: DescribeAcceleratorRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly
  ]
  def provisionByoipCidr(request: ProvisionByoipCidrRequest): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly
  ]
  def listCustomRoutingListeners(
      request: ListCustomRoutingListenersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
  ]
  def listCustomRoutingListenersPaginated(
      request: ListCustomRoutingListenersRequest
  ): IO[
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly
  ]
}
object GlobalAccelerator {
  val live: ZLayer[AwsConfig, java.lang.Throwable, GlobalAccelerator] =
    customized(identity)
  def customized(
      customization: GlobalAcceleratorAsyncClientBuilder => GlobalAcceleratorAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, GlobalAccelerator] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: GlobalAcceleratorAsyncClientBuilder => GlobalAcceleratorAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, GlobalAccelerator] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = GlobalAcceleratorAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      GlobalAcceleratorAsyncClient,
      GlobalAcceleratorAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      GlobalAcceleratorAsyncClient,
      GlobalAcceleratorAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new GlobalAcceleratorImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class GlobalAcceleratorImpl[R](
      override val api: GlobalAcceleratorAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends GlobalAccelerator
      with AwsServiceBase[R] {
    override val serviceName: String = "GlobalAccelerator"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): GlobalAcceleratorImpl[R1] = new GlobalAcceleratorImpl(api, newAspect, r)
    def updateAcceleratorAttributes(
        request: UpdateAcceleratorAttributesRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest,
      UpdateAcceleratorAttributesResponse
    ]("updateAcceleratorAttributes", api.updateAcceleratorAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.wrap
    ).provideEnvironment(r)
    def deleteEndpointGroup(
        request: DeleteEndpointGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest,
      DeleteEndpointGroupResponse
    ]("deleteEndpointGroup", api.deleteEndpointGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listCustomRoutingPortMappings(
        request: ListCustomRoutingPortMappingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.PortMapping.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest,
      ListCustomRoutingPortMappingsResponse,
      PortMapping
    ](
      "listCustomRoutingPortMappings",
      api.listCustomRoutingPortMappings,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.portMappings().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.globalaccelerator.model.PortMapping.wrap(item))
      .provideEnvironment(r)
    def listCustomRoutingPortMappingsPaginated(
        request: ListCustomRoutingPortMappingsRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest,
      ListCustomRoutingPortMappingsResponse
    ]("listCustomRoutingPortMappings", api.listCustomRoutingPortMappings)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.wrap
    ).provideEnvironment(r)
    def createEndpointGroup(request: CreateEndpointGroupRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest,
      CreateEndpointGroupResponse
    ]("createEndpointGroup", api.createEndpointGroup)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.wrap)
      .provideEnvironment(r)
    def createCustomRoutingListener(
        request: CreateCustomRoutingListenerRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.CreateCustomRoutingListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest,
      CreateCustomRoutingListenerResponse
    ]("createCustomRoutingListener", api.createCustomRoutingListener)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.CreateCustomRoutingListenerResponse.wrap
    ).provideEnvironment(r)
    def updateCustomRoutingAcceleratorAttributes(
        request: UpdateCustomRoutingAcceleratorAttributesRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest,
      UpdateCustomRoutingAcceleratorAttributesResponse
    ](
      "updateCustomRoutingAcceleratorAttributes",
      api.updateCustomRoutingAcceleratorAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def updateCustomRoutingAccelerator(
        request: UpdateCustomRoutingAcceleratorRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest,
      UpdateCustomRoutingAcceleratorResponse
    ]("updateCustomRoutingAccelerator", api.updateCustomRoutingAccelerator)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.wrap
    ).provideEnvironment(r)
    def describeAcceleratorAttributes(
        request: DescribeAcceleratorAttributesRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest,
      DescribeAcceleratorAttributesResponse
    ]("describeAcceleratorAttributes", api.describeAcceleratorAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.wrap
    ).provideEnvironment(r)
    def describeEndpointGroup(request: DescribeEndpointGroupRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest,
      DescribeEndpointGroupResponse
    ]("describeEndpointGroup", api.describeEndpointGroup)(
      request.buildAwsValue()
    ).map(zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.wrap)
      .provideEnvironment(r)
    def listEndpointGroups(request: ListEndpointGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest,
      ListEndpointGroupsResponse,
      EndpointGroup
    ](
      "listEndpointGroups",
      api.listEndpointGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.endpointGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.globalaccelerator.model.EndpointGroup.wrap(item))
      .provideEnvironment(r)
    def listEndpointGroupsPaginated(request: ListEndpointGroupsRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest,
      ListEndpointGroupsResponse
    ]("listEndpointGroups", api.listEndpointGroups)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.wrap)
      .provideEnvironment(r)
    def listCustomRoutingAccelerators(
        request: ListCustomRoutingAcceleratorsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest,
      ListCustomRoutingAcceleratorsResponse,
      CustomRoutingAccelerator
    ](
      "listCustomRoutingAccelerators",
      api.listCustomRoutingAccelerators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accelerators().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.globalaccelerator.model.CustomRoutingAccelerator.wrap(item)
      )
      .provideEnvironment(r)
    def listCustomRoutingAcceleratorsPaginated(
        request: ListCustomRoutingAcceleratorsRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest,
      ListCustomRoutingAcceleratorsResponse
    ]("listCustomRoutingAccelerators", api.listCustomRoutingAccelerators)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.wrap
    ).provideEnvironment(r)
    def createAccelerator(request: CreateAcceleratorRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest,
      CreateAcceleratorResponse
    ]("createAccelerator", api.createAccelerator)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.CreateAcceleratorResponse.wrap)
      .provideEnvironment(r)
    def deleteCustomRoutingEndpointGroup(
        request: DeleteCustomRoutingEndpointGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest,
      DeleteCustomRoutingEndpointGroupResponse
    ]("deleteCustomRoutingEndpointGroup", api.deleteCustomRoutingEndpointGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteListener(request: DeleteListenerRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest,
        DeleteListenerResponse
      ]("deleteListener", api.deleteListener)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteCustomRoutingListener(
        request: DeleteCustomRoutingListenerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest,
      DeleteCustomRoutingListenerResponse
    ]("deleteCustomRoutingListener", api.deleteCustomRoutingListener)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateEndpointGroup(request: UpdateEndpointGroupRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest,
      UpdateEndpointGroupResponse
    ]("updateEndpointGroup", api.updateEndpointGroup)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.wrap)
      .provideEnvironment(r)
    def deprovisionByoipCidr(request: DeprovisionByoipCidrRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DeprovisionByoipCidrResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest,
      DeprovisionByoipCidrResponse
    ]("deprovisionByoipCidr", api.deprovisionByoipCidr)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.DeprovisionByoipCidrResponse.wrap)
      .provideEnvironment(r)
    def describeListener(request: DescribeListenerRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest,
      DescribeListenerResponse
    ]("describeListener", api.describeListener)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.DescribeListenerResponse.wrap)
      .provideEnvironment(r)
    def deleteAccelerator(
        request: DeleteAcceleratorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest,
      DeleteAcceleratorResponse
    ]("deleteAccelerator", api.deleteAccelerator)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def addCustomRoutingEndpoints(
        request: AddCustomRoutingEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest,
      AddCustomRoutingEndpointsResponse
    ]("addCustomRoutingEndpoints", api.addCustomRoutingEndpoints)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.wrap
    ).provideEnvironment(r)
    def listCustomRoutingEndpointGroups(
        request: ListCustomRoutingEndpointGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest,
      ListCustomRoutingEndpointGroupsResponse,
      CustomRoutingEndpointGroup
    ](
      "listCustomRoutingEndpointGroups",
      api.listCustomRoutingEndpointGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.endpointGroups().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.wrap(item)
      )
      .provideEnvironment(r)
    def listCustomRoutingEndpointGroupsPaginated(
        request: ListCustomRoutingEndpointGroupsRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest,
      ListCustomRoutingEndpointGroupsResponse
    ]("listCustomRoutingEndpointGroups", api.listCustomRoutingEndpointGroups)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.wrap
    ).provideEnvironment(r)
    def listByoipCidrs(request: ListByoipCidrsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest,
      ListByoipCidrsResponse,
      ByoipCidr
    ](
      "listByoipCidrs",
      api.listByoipCidrs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.byoipCidrs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.globalaccelerator.model.ByoipCidr.wrap(item))
      .provideEnvironment(r)
    def listByoipCidrsPaginated(request: ListByoipCidrsRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest,
      ListByoipCidrsResponse
    ]("listByoipCidrs", api.listByoipCidrs)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.ListByoipCidrsResponse.wrap)
      .provideEnvironment(r)
    def updateCustomRoutingListener(
        request: UpdateCustomRoutingListenerRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest,
      UpdateCustomRoutingListenerResponse
    ]("updateCustomRoutingListener", api.updateCustomRoutingListener)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.wrap
    ).provideEnvironment(r)
    def createCustomRoutingAccelerator(
        request: CreateCustomRoutingAcceleratorRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest,
      CreateCustomRoutingAcceleratorResponse
    ]("createCustomRoutingAccelerator", api.createCustomRoutingAccelerator)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse.wrap
    ).provideEnvironment(r)
    def describeCustomRoutingEndpointGroup(
        request: DescribeCustomRoutingEndpointGroupRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest,
      DescribeCustomRoutingEndpointGroupResponse
    ](
      "describeCustomRoutingEndpointGroup",
      api.describeCustomRoutingEndpointGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse.wrap
      )
      .provideEnvironment(r)
    def createListener(request: CreateListenerRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.CreateListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest,
      CreateListenerResponse
    ]("createListener", api.createListener)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.CreateListenerResponse.wrap)
      .provideEnvironment(r)
    def describeCustomRoutingListener(
        request: DescribeCustomRoutingListenerRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest,
      DescribeCustomRoutingListenerResponse
    ]("describeCustomRoutingListener", api.describeCustomRoutingListener)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.wrap
    ).provideEnvironment(r)
    def allowCustomRoutingTraffic(
        request: AllowCustomRoutingTrafficRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest,
      AllowCustomRoutingTrafficResponse
    ]("allowCustomRoutingTraffic", api.allowCustomRoutingTraffic)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def removeCustomRoutingEndpoints(
        request: RemoveCustomRoutingEndpointsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest,
      RemoveCustomRoutingEndpointsResponse
    ]("removeCustomRoutingEndpoints", api.removeCustomRoutingEndpoints)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeCustomRoutingAcceleratorAttributes(
        request: DescribeCustomRoutingAcceleratorAttributesRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest,
      DescribeCustomRoutingAcceleratorAttributesResponse
    ](
      "describeCustomRoutingAcceleratorAttributes",
      api.describeCustomRoutingAcceleratorAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def describeCustomRoutingAccelerator(
        request: DescribeCustomRoutingAcceleratorRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest,
      DescribeCustomRoutingAcceleratorResponse
    ]("describeCustomRoutingAccelerator", api.describeCustomRoutingAccelerator)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse.wrap
    ).provideEnvironment(r)
    def listCustomRoutingPortMappingsByDestination(
        request: ListCustomRoutingPortMappingsByDestinationRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest,
      ListCustomRoutingPortMappingsByDestinationResponse,
      DestinationPortMapping
    ](
      "listCustomRoutingPortMappingsByDestination",
      api.listCustomRoutingPortMappingsByDestination,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.destinationPortMappings().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.globalaccelerator.model.DestinationPortMapping.wrap(item)
      )
      .provideEnvironment(r)
    def listCustomRoutingPortMappingsByDestinationPaginated(
        request: ListCustomRoutingPortMappingsByDestinationRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest,
      ListCustomRoutingPortMappingsByDestinationResponse
    ](
      "listCustomRoutingPortMappingsByDestination",
      api.listCustomRoutingPortMappingsByDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def withdrawByoipCidr(request: WithdrawByoipCidrRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest,
      WithdrawByoipCidrResponse
    ]("withdrawByoipCidr", api.withdrawByoipCidr)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listAccelerators(request: ListAcceleratorsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Accelerator.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest,
      ListAcceleratorsResponse,
      Accelerator
    ](
      "listAccelerators",
      api.listAccelerators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accelerators().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.globalaccelerator.model.Accelerator.wrap(item))
      .provideEnvironment(r)
    def listAcceleratorsPaginated(request: ListAcceleratorsRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest,
      ListAcceleratorsResponse
    ]("listAccelerators", api.listAccelerators)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.ListAcceleratorsResponse.wrap)
      .provideEnvironment(r)
    def advertiseByoipCidr(request: AdvertiseByoipCidrRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest,
      AdvertiseByoipCidrResponse
    ]("advertiseByoipCidr", api.advertiseByoipCidr)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateListener(request: UpdateListenerRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest,
      UpdateListenerResponse
    ]("updateListener", api.updateListener)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.UpdateListenerResponse.wrap)
      .provideEnvironment(r)
    def updateAccelerator(request: UpdateAcceleratorRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest,
      UpdateAcceleratorResponse
    ]("updateAccelerator", api.updateAccelerator)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.wrap)
      .provideEnvironment(r)
    def createCustomRoutingEndpointGroup(
        request: CreateCustomRoutingEndpointGroupRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest,
      CreateCustomRoutingEndpointGroupResponse
    ]("createCustomRoutingEndpointGroup", api.createCustomRoutingEndpointGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.wrap
    ).provideEnvironment(r)
    def denyCustomRoutingTraffic(
        request: DenyCustomRoutingTrafficRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest,
      DenyCustomRoutingTrafficResponse
    ]("denyCustomRoutingTraffic", api.denyCustomRoutingTraffic)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteCustomRoutingAccelerator(
        request: DeleteCustomRoutingAcceleratorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest,
      DeleteCustomRoutingAcceleratorResponse
    ]("deleteCustomRoutingAccelerator", api.deleteCustomRoutingAccelerator)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listListeners(request: ListListenersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Listener.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest,
      ListListenersResponse,
      Listener
    ](
      "listListeners",
      api.listListeners,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.listeners().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.globalaccelerator.model.Listener.wrap(item))
      .provideEnvironment(r)
    def listListenersPaginated(request: ListListenersRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest,
      ListListenersResponse
    ]("listListeners", api.listListeners)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.ListListenersResponse.wrap)
      .provideEnvironment(r)
    def describeAccelerator(request: DescribeAcceleratorRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest,
      DescribeAcceleratorResponse
    ]("describeAccelerator", api.describeAccelerator)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.wrap)
      .provideEnvironment(r)
    def provisionByoipCidr(request: ProvisionByoipCidrRequest): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest,
      ProvisionByoipCidrResponse
    ]("provisionByoipCidr", api.provisionByoipCidr)(request.buildAwsValue())
      .map(zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.wrap)
      .provideEnvironment(r)
    def listCustomRoutingListeners(
        request: ListCustomRoutingListenersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest,
      ListCustomRoutingListenersResponse,
      CustomRoutingListener
    ](
      "listCustomRoutingListeners",
      api.listCustomRoutingListeners,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.listeners().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.globalaccelerator.model.CustomRoutingListener.wrap(item)
      )
      .provideEnvironment(r)
    def listCustomRoutingListenersPaginated(
        request: ListCustomRoutingListenersRequest
    ): IO[
      AwsError,
      zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest,
      ListCustomRoutingListenersResponse
    ]("listCustomRoutingListeners", api.listCustomRoutingListeners)(
      request.buildAwsValue()
    ).map(
      zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.wrap
    ).provideEnvironment(r)
  }
  def updateAcceleratorAttributes(
      request: UpdateAcceleratorAttributesRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAcceleratorAttributes(request))
  def deleteEndpointGroup(
      request: DeleteEndpointGroupRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEndpointGroup(request))
  def listCustomRoutingPortMappings(
      request: ListCustomRoutingPortMappingsRequest
  ): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.PortMapping.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomRoutingPortMappings(request))
  def listCustomRoutingPortMappingsPaginated(
      request: ListCustomRoutingPortMappingsRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomRoutingPortMappingsPaginated(request))
  def createEndpointGroup(request: CreateEndpointGroupRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpointGroup(request))
  def createCustomRoutingListener(
      request: CreateCustomRoutingListenerRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CreateCustomRoutingListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomRoutingListener(request))
  def updateCustomRoutingAcceleratorAttributes(
      request: UpdateCustomRoutingAcceleratorAttributesRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCustomRoutingAcceleratorAttributes(request))
  def updateCustomRoutingAccelerator(
      request: UpdateCustomRoutingAcceleratorRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCustomRoutingAccelerator(request))
  def describeAcceleratorAttributes(
      request: DescribeAcceleratorAttributesRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAcceleratorAttributes(request))
  def describeEndpointGroup(request: DescribeEndpointGroupRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointGroup(request))
  def listEndpointGroups(request: ListEndpointGroupsRequest): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listEndpointGroups(request))
  def listEndpointGroupsPaginated(request: ListEndpointGroupsRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEndpointGroupsPaginated(request))
  def listCustomRoutingAccelerators(
      request: ListCustomRoutingAcceleratorsRequest
  ): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomRoutingAccelerators(request))
  def listCustomRoutingAcceleratorsPaginated(
      request: ListCustomRoutingAcceleratorsRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomRoutingAcceleratorsPaginated(request))
  def createAccelerator(request: CreateAcceleratorRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccelerator(request))
  def deleteCustomRoutingEndpointGroup(
      request: DeleteCustomRoutingEndpointGroupRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCustomRoutingEndpointGroup(request))
  def deleteListener(
      request: DeleteListenerRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteListener(request))
  def deleteCustomRoutingListener(
      request: DeleteCustomRoutingListenerRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCustomRoutingListener(request))
  def updateEndpointGroup(request: UpdateEndpointGroupRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpointGroup(request))
  def deprovisionByoipCidr(request: DeprovisionByoipCidrRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DeprovisionByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deprovisionByoipCidr(request))
  def describeListener(request: DescribeListenerRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeListener(request))
  def deleteAccelerator(
      request: DeleteAcceleratorRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccelerator(request))
  def addCustomRoutingEndpoints(request: AddCustomRoutingEndpointsRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addCustomRoutingEndpoints(request))
  def listCustomRoutingEndpointGroups(
      request: ListCustomRoutingEndpointGroupsRequest
  ): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomRoutingEndpointGroups(request))
  def listCustomRoutingEndpointGroupsPaginated(
      request: ListCustomRoutingEndpointGroupsRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomRoutingEndpointGroupsPaginated(request))
  def listByoipCidrs(request: ListByoipCidrsRequest): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
  ] = ZStream.serviceWithStream(_.listByoipCidrs(request))
  def listByoipCidrsPaginated(request: ListByoipCidrsRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listByoipCidrsPaginated(request))
  def updateCustomRoutingListener(
      request: UpdateCustomRoutingListenerRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCustomRoutingListener(request))
  def createCustomRoutingAccelerator(
      request: CreateCustomRoutingAcceleratorRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomRoutingAccelerator(request))
  def describeCustomRoutingEndpointGroup(
      request: DescribeCustomRoutingEndpointGroupRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomRoutingEndpointGroup(request))
  def createListener(request: CreateListenerRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CreateListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createListener(request))
  def describeCustomRoutingListener(
      request: DescribeCustomRoutingListenerRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomRoutingListener(request))
  def allowCustomRoutingTraffic(
      request: AllowCustomRoutingTrafficRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.allowCustomRoutingTraffic(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def removeCustomRoutingEndpoints(
      request: RemoveCustomRoutingEndpointsRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeCustomRoutingEndpoints(request))
  def describeCustomRoutingAcceleratorAttributes(
      request: DescribeCustomRoutingAcceleratorAttributesRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomRoutingAcceleratorAttributes(request))
  def describeCustomRoutingAccelerator(
      request: DescribeCustomRoutingAcceleratorRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeCustomRoutingAccelerator(request))
  def listCustomRoutingPortMappingsByDestination(
      request: ListCustomRoutingPortMappingsByDestinationRequest
  ): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listCustomRoutingPortMappingsByDestination(request)
  )
  def listCustomRoutingPortMappingsByDestinationPaginated(
      request: ListCustomRoutingPortMappingsByDestinationRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listCustomRoutingPortMappingsByDestinationPaginated(request)
  )
  def withdrawByoipCidr(request: WithdrawByoipCidrRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.withdrawByoipCidr(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listAccelerators(request: ListAcceleratorsRequest): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.Accelerator.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccelerators(request))
  def listAcceleratorsPaginated(request: ListAcceleratorsRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAcceleratorsPaginated(request))
  def advertiseByoipCidr(request: AdvertiseByoipCidrRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.advertiseByoipCidr(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateListener(request: UpdateListenerRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateListener(request))
  def updateAccelerator(request: UpdateAcceleratorRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccelerator(request))
  def createCustomRoutingEndpointGroup(
      request: CreateCustomRoutingEndpointGroupRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomRoutingEndpointGroup(request))
  def denyCustomRoutingTraffic(
      request: DenyCustomRoutingTrafficRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.denyCustomRoutingTraffic(request))
  def deleteCustomRoutingAccelerator(
      request: DeleteCustomRoutingAcceleratorRequest
  ): ZIO[zio.aws.globalaccelerator.GlobalAccelerator, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCustomRoutingAccelerator(request))
  def listListeners(request: ListListenersRequest): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.Listener.ReadOnly
  ] = ZStream.serviceWithStream(_.listListeners(request))
  def listListenersPaginated(request: ListListenersRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listListenersPaginated(request))
  def describeAccelerator(request: DescribeAcceleratorRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccelerator(request))
  def provisionByoipCidr(request: ProvisionByoipCidrRequest): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.provisionByoipCidr(request))
  def listCustomRoutingListeners(
      request: ListCustomRoutingListenersRequest
  ): ZStream[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomRoutingListeners(request))
  def listCustomRoutingListenersPaginated(
      request: ListCustomRoutingListenersRequest
  ): ZIO[
    zio.aws.globalaccelerator.GlobalAccelerator,
    AwsError,
    zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomRoutingListenersPaginated(request))
}
