package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.globalaccelerator.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.TagResourceRequest.ReadOnly =
    zio.aws.globalaccelerator.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.TagResourceRequest =
      zio.aws.globalaccelerator.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.globalaccelerator.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest
  ) extends zio.aws.globalaccelerator.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.globalaccelerator.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.globalaccelerator.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest
  ): zio.aws.globalaccelerator.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
