package zio.aws.globalaccelerator
import zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.globalaccelerator.model.{
  DescribeCustomRoutingEndpointGroupRequest,
  UpdateAcceleratorRequest,
  AllowCustomRoutingTrafficRequest,
  DescribeAcceleratorRequest,
  ListCustomRoutingEndpointGroupsRequest,
  DescribeCustomRoutingAcceleratorAttributesRequest,
  ListListenersRequest,
  DescribeListenerRequest,
  DeleteAcceleratorRequest,
  ListAcceleratorsRequest,
  ListCustomRoutingPortMappingsRequest,
  CreateAcceleratorRequest,
  DeleteCustomRoutingEndpointGroupRequest,
  DescribeAcceleratorAttributesRequest,
  CreateCustomRoutingListenerRequest,
  ListCustomRoutingAcceleratorsRequest,
  UpdateAcceleratorAttributesRequest,
  DescribeCustomRoutingAcceleratorRequest,
  ListTagsForResourceRequest,
  UpdateCustomRoutingAcceleratorRequest,
  CreateCustomRoutingEndpointGroupRequest,
  DenyCustomRoutingTrafficRequest,
  ListCustomRoutingPortMappingsByDestinationRequest,
  ListEndpointGroupsRequest,
  UpdateEndpointGroupRequest,
  UpdateListenerRequest,
  ListByoipCidrsRequest,
  ProvisionByoipCidrRequest,
  AdvertiseByoipCidrRequest,
  DeprovisionByoipCidrRequest,
  UpdateCustomRoutingAcceleratorAttributesRequest,
  UntagResourceRequest,
  DeleteEndpointGroupRequest,
  AddCustomRoutingEndpointsRequest,
  DeleteCustomRoutingListenerRequest,
  RemoveCustomRoutingEndpointsRequest,
  UpdateCustomRoutingListenerRequest,
  CreateEndpointGroupRequest,
  CreateCustomRoutingAcceleratorRequest,
  DeleteListenerRequest,
  CreateListenerRequest,
  DescribeEndpointGroupRequest,
  ListCustomRoutingListenersRequest,
  DescribeCustomRoutingListenerRequest,
  TagResourceRequest,
  DeleteCustomRoutingAcceleratorRequest,
  WithdrawByoipCidrRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient
import zio.stream.ZStream
object GlobalAcceleratorMock extends Mock[GlobalAccelerator] {
  object UpdateAcceleratorAttributes
      extends Effect[
        UpdateAcceleratorAttributesRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly
      ]
  object DeleteEndpointGroup
      extends Effect[DeleteEndpointGroupRequest, AwsError, Unit]
  object ListCustomRoutingPortMappings
      extends Stream[
        ListCustomRoutingPortMappingsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.PortMapping.ReadOnly
      ]
  object ListCustomRoutingPortMappingsPaginated
      extends Effect[
        ListCustomRoutingPortMappingsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly
      ]
  object CreateEndpointGroup
      extends Effect[
        CreateEndpointGroupRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly
      ]
  object CreateCustomRoutingListener
      extends Effect[
        CreateCustomRoutingListenerRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CreateCustomRoutingListenerResponse.ReadOnly
      ]
  object UpdateCustomRoutingAcceleratorAttributes
      extends Effect[
        UpdateCustomRoutingAcceleratorAttributesRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly
      ]
  object UpdateCustomRoutingAccelerator
      extends Effect[
        UpdateCustomRoutingAcceleratorRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly
      ]
  object DescribeAcceleratorAttributes
      extends Effect[
        DescribeAcceleratorAttributesRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly
      ]
  object DescribeEndpointGroup
      extends Effect[
        DescribeEndpointGroupRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly
      ]
  object ListEndpointGroups
      extends Stream[
        ListEndpointGroupsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
      ]
  object ListEndpointGroupsPaginated
      extends Effect[
        ListEndpointGroupsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly
      ]
  object ListCustomRoutingAccelerators
      extends Stream[
        ListCustomRoutingAcceleratorsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
      ]
  object ListCustomRoutingAcceleratorsPaginated
      extends Effect[
        ListCustomRoutingAcceleratorsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly
      ]
  object CreateAccelerator
      extends Effect[
        CreateAcceleratorRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly
      ]
  object DeleteCustomRoutingEndpointGroup
      extends Effect[DeleteCustomRoutingEndpointGroupRequest, AwsError, Unit]
  object DeleteListener extends Effect[DeleteListenerRequest, AwsError, Unit]
  object DeleteCustomRoutingListener
      extends Effect[DeleteCustomRoutingListenerRequest, AwsError, Unit]
  object UpdateEndpointGroup
      extends Effect[
        UpdateEndpointGroupRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly
      ]
  object DeprovisionByoipCidr
      extends Effect[
        DeprovisionByoipCidrRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DeprovisionByoipCidrResponse.ReadOnly
      ]
  object DescribeListener
      extends Effect[
        DescribeListenerRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly
      ]
  object DeleteAccelerator
      extends Effect[DeleteAcceleratorRequest, AwsError, Unit]
  object AddCustomRoutingEndpoints
      extends Effect[
        AddCustomRoutingEndpointsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly
      ]
  object ListCustomRoutingEndpointGroups
      extends Stream[
        ListCustomRoutingEndpointGroupsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
      ]
  object ListCustomRoutingEndpointGroupsPaginated
      extends Effect[
        ListCustomRoutingEndpointGroupsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly
      ]
  object ListByoipCidrs
      extends Stream[
        ListByoipCidrsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
      ]
  object ListByoipCidrsPaginated
      extends Effect[
        ListByoipCidrsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly
      ]
  object UpdateCustomRoutingListener
      extends Effect[
        UpdateCustomRoutingListenerRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly
      ]
  object CreateCustomRoutingAccelerator
      extends Effect[
        CreateCustomRoutingAcceleratorRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse.ReadOnly
      ]
  object DescribeCustomRoutingEndpointGroup
      extends Effect[
        DescribeCustomRoutingEndpointGroupRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse.ReadOnly
      ]
  object CreateListener
      extends Effect[
        CreateListenerRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CreateListenerResponse.ReadOnly
      ]
  object DescribeCustomRoutingListener
      extends Effect[
        DescribeCustomRoutingListenerRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly
      ]
  object AllowCustomRoutingTraffic
      extends Effect[AllowCustomRoutingTrafficRequest, AwsError, Unit]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UntagResourceResponse.ReadOnly
      ]
  object RemoveCustomRoutingEndpoints
      extends Effect[RemoveCustomRoutingEndpointsRequest, AwsError, Unit]
  object DescribeCustomRoutingAcceleratorAttributes
      extends Effect[
        DescribeCustomRoutingAcceleratorAttributesRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse.ReadOnly
      ]
  object DescribeCustomRoutingAccelerator
      extends Effect[
        DescribeCustomRoutingAcceleratorRequest,
        AwsError,
        ReadOnly
      ]
  object ListCustomRoutingPortMappingsByDestination
      extends Stream[
        ListCustomRoutingPortMappingsByDestinationRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly
      ]
  object ListCustomRoutingPortMappingsByDestinationPaginated
      extends Effect[
        ListCustomRoutingPortMappingsByDestinationRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly
      ]
  object WithdrawByoipCidr
      extends Effect[
        WithdrawByoipCidrRequest,
        AwsError,
        zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListAccelerators
      extends Stream[
        ListAcceleratorsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.Accelerator.ReadOnly
      ]
  object ListAcceleratorsPaginated
      extends Effect[
        ListAcceleratorsRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly
      ]
  object AdvertiseByoipCidr
      extends Effect[
        AdvertiseByoipCidrRequest,
        AwsError,
        zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.globalaccelerator.model.TagResourceResponse.ReadOnly
      ]
  object UpdateListener
      extends Effect[
        UpdateListenerRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly
      ]
  object UpdateAccelerator
      extends Effect[
        UpdateAcceleratorRequest,
        AwsError,
        zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly
      ]
  object CreateCustomRoutingEndpointGroup
      extends Effect[
        CreateCustomRoutingEndpointGroupRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly
      ]
  object DenyCustomRoutingTraffic
      extends Effect[DenyCustomRoutingTrafficRequest, AwsError, Unit]
  object DeleteCustomRoutingAccelerator
      extends Effect[DeleteCustomRoutingAcceleratorRequest, AwsError, Unit]
  object ListListeners
      extends Stream[
        ListListenersRequest,
        AwsError,
        zio.aws.globalaccelerator.model.Listener.ReadOnly
      ]
  object ListListenersPaginated
      extends Effect[
        ListListenersRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly
      ]
  object DescribeAccelerator
      extends Effect[
        DescribeAcceleratorRequest,
        AwsError,
        zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly
      ]
  object ProvisionByoipCidr
      extends Effect[
        ProvisionByoipCidrRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly
      ]
  object ListCustomRoutingListeners
      extends Stream[
        ListCustomRoutingListenersRequest,
        AwsError,
        zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
      ]
  object ListCustomRoutingListenersPaginated
      extends Effect[
        ListCustomRoutingListenersRequest,
        AwsError,
        zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, GlobalAccelerator] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, GlobalAccelerator] { rts =>
        zio.ZIO.succeed {
          new GlobalAccelerator {
            val api: GlobalAcceleratorAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): GlobalAccelerator = this
            def updateAcceleratorAttributes(
                request: UpdateAcceleratorAttributesRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly
            ] = proxy(UpdateAcceleratorAttributes, request)
            def deleteEndpointGroup(
                request: DeleteEndpointGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteEndpointGroup, request)
            def listCustomRoutingPortMappings(
                request: ListCustomRoutingPortMappingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.PortMapping.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomRoutingPortMappings, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomRoutingPortMappingsPaginated(
                request: ListCustomRoutingPortMappingsRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly
            ] = proxy(ListCustomRoutingPortMappingsPaginated, request)
            def createEndpointGroup(request: CreateEndpointGroupRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly
            ] = proxy(CreateEndpointGroup, request)
            def createCustomRoutingListener(
                request: CreateCustomRoutingListenerRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.CreateCustomRoutingListenerResponse.ReadOnly
            ] = proxy(CreateCustomRoutingListener, request)
            def updateCustomRoutingAcceleratorAttributes(
                request: UpdateCustomRoutingAcceleratorAttributesRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly
            ] = proxy(UpdateCustomRoutingAcceleratorAttributes, request)
            def updateCustomRoutingAccelerator(
                request: UpdateCustomRoutingAcceleratorRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly
            ] = proxy(UpdateCustomRoutingAccelerator, request)
            def describeAcceleratorAttributes(
                request: DescribeAcceleratorAttributesRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly
            ] = proxy(DescribeAcceleratorAttributes, request)
            def describeEndpointGroup(
                request: DescribeEndpointGroupRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly
            ] = proxy(DescribeEndpointGroup, request)
            def listEndpointGroups(request: ListEndpointGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEndpointGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEndpointGroupsPaginated(
                request: ListEndpointGroupsRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly
            ] = proxy(ListEndpointGroupsPaginated, request)
            def listCustomRoutingAccelerators(
                request: ListCustomRoutingAcceleratorsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomRoutingAccelerators, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomRoutingAcceleratorsPaginated(
                request: ListCustomRoutingAcceleratorsRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly
            ] = proxy(ListCustomRoutingAcceleratorsPaginated, request)
            def createAccelerator(request: CreateAcceleratorRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly
            ] = proxy(CreateAccelerator, request)
            def deleteCustomRoutingEndpointGroup(
                request: DeleteCustomRoutingEndpointGroupRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteCustomRoutingEndpointGroup, request)
            def deleteListener(
                request: DeleteListenerRequest
            ): IO[AwsError, Unit] = proxy(DeleteListener, request)
            def deleteCustomRoutingListener(
                request: DeleteCustomRoutingListenerRequest
            ): IO[AwsError, Unit] = proxy(DeleteCustomRoutingListener, request)
            def updateEndpointGroup(request: UpdateEndpointGroupRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly
            ] = proxy(UpdateEndpointGroup, request)
            def deprovisionByoipCidr(request: DeprovisionByoipCidrRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DeprovisionByoipCidrResponse.ReadOnly
            ] = proxy(DeprovisionByoipCidr, request)
            def describeListener(request: DescribeListenerRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly
            ] = proxy(DescribeListener, request)
            def deleteAccelerator(
                request: DeleteAcceleratorRequest
            ): IO[AwsError, Unit] = proxy(DeleteAccelerator, request)
            def addCustomRoutingEndpoints(
                request: AddCustomRoutingEndpointsRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly
            ] = proxy(AddCustomRoutingEndpoints, request)
            def listCustomRoutingEndpointGroups(
                request: ListCustomRoutingEndpointGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomRoutingEndpointGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomRoutingEndpointGroupsPaginated(
                request: ListCustomRoutingEndpointGroupsRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly
            ] = proxy(ListCustomRoutingEndpointGroupsPaginated, request)
            def listByoipCidrs(request: ListByoipCidrsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListByoipCidrs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listByoipCidrsPaginated(request: ListByoipCidrsRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly
            ] = proxy(ListByoipCidrsPaginated, request)
            def updateCustomRoutingListener(
                request: UpdateCustomRoutingListenerRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly
            ] = proxy(UpdateCustomRoutingListener, request)
            def createCustomRoutingAccelerator(
                request: CreateCustomRoutingAcceleratorRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse.ReadOnly
            ] = proxy(CreateCustomRoutingAccelerator, request)
            def describeCustomRoutingEndpointGroup(
                request: DescribeCustomRoutingEndpointGroupRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse.ReadOnly
            ] = proxy(DescribeCustomRoutingEndpointGroup, request)
            def createListener(request: CreateListenerRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.CreateListenerResponse.ReadOnly
            ] = proxy(CreateListener, request)
            def describeCustomRoutingListener(
                request: DescribeCustomRoutingListenerRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly
            ] = proxy(DescribeCustomRoutingListener, request)
            def allowCustomRoutingTraffic(
                request: AllowCustomRoutingTrafficRequest
            ): IO[AwsError, Unit] = proxy(AllowCustomRoutingTraffic, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def removeCustomRoutingEndpoints(
                request: RemoveCustomRoutingEndpointsRequest
            ): IO[AwsError, Unit] = proxy(RemoveCustomRoutingEndpoints, request)
            def describeCustomRoutingAcceleratorAttributes(
                request: DescribeCustomRoutingAcceleratorAttributesRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse.ReadOnly
            ] = proxy(DescribeCustomRoutingAcceleratorAttributes, request)
            def describeCustomRoutingAccelerator(
                request: DescribeCustomRoutingAcceleratorRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DescribeCustomRoutingAccelerator, request)
            def listCustomRoutingPortMappingsByDestination(
                request: ListCustomRoutingPortMappingsByDestinationRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomRoutingPortMappingsByDestination, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomRoutingPortMappingsByDestinationPaginated(
                request: ListCustomRoutingPortMappingsByDestinationRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly
            ] = proxy(
              ListCustomRoutingPortMappingsByDestinationPaginated,
              request
            )
            def withdrawByoipCidr(request: WithdrawByoipCidrRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly
            ] = proxy(WithdrawByoipCidr, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listAccelerators(request: ListAcceleratorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.Accelerator.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccelerators, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAcceleratorsPaginated(request: ListAcceleratorsRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly
            ] = proxy(ListAcceleratorsPaginated, request)
            def advertiseByoipCidr(request: AdvertiseByoipCidrRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly
            ] = proxy(AdvertiseByoipCidr, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateListener(request: UpdateListenerRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly
            ] = proxy(UpdateListener, request)
            def updateAccelerator(request: UpdateAcceleratorRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly
            ] = proxy(UpdateAccelerator, request)
            def createCustomRoutingEndpointGroup(
                request: CreateCustomRoutingEndpointGroupRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly
            ] = proxy(CreateCustomRoutingEndpointGroup, request)
            def denyCustomRoutingTraffic(
                request: DenyCustomRoutingTrafficRequest
            ): IO[AwsError, Unit] = proxy(DenyCustomRoutingTraffic, request)
            def deleteCustomRoutingAccelerator(
                request: DeleteCustomRoutingAcceleratorRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteCustomRoutingAccelerator, request)
            def listListeners(request: ListListenersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.Listener.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListListeners, request)
                }
                .getOrThrowFiberFailure()
            }
            def listListenersPaginated(request: ListListenersRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly
            ] = proxy(ListListenersPaginated, request)
            def describeAccelerator(request: DescribeAcceleratorRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly
            ] = proxy(DescribeAccelerator, request)
            def provisionByoipCidr(request: ProvisionByoipCidrRequest): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly
            ] = proxy(ProvisionByoipCidr, request)
            def listCustomRoutingListeners(
                request: ListCustomRoutingListenersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomRoutingListeners, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomRoutingListenersPaginated(
                request: ListCustomRoutingListenersRequest
            ): IO[
              AwsError,
              zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly
            ] = proxy(ListCustomRoutingListenersPaginated, request)
          }
        }
      }
    }
  }
}
