package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class WithdrawByoipCidrRequest(cidr: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest = {
    import WithdrawByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.WithdrawByoipCidrRequest.ReadOnly =
    zio.aws.globalaccelerator.model.WithdrawByoipCidrRequest
      .wrap(buildAwsValue())
}
object WithdrawByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.WithdrawByoipCidrRequest =
      zio.aws.globalaccelerator.model.WithdrawByoipCidrRequest(cidr)
    def cidr: GenericString
    def getCidr: ZIO[Any, Nothing, GenericString] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest
  ) extends zio.aws.globalaccelerator.model.WithdrawByoipCidrRequest.ReadOnly {
    override val cidr: GenericString = impl.cidr(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest
  ): zio.aws.globalaccelerator.model.WithdrawByoipCidrRequest.ReadOnly =
    new Wrapper(impl)
}
