package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingAcceleratorsResponse(
    accelerators: Optional[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingAccelerator]
    ] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse = {
    import ListCustomRoutingAcceleratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
      .builder()
      .optionallyWith(
        accelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accelerators)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingAcceleratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse =
      zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse(
        accelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accelerators: Optional[
      List[zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly]
    ]
    def nextToken: Optional[GenericString]
    def getAccelerators: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ]] = AwsError.unwrapOptionField("accelerators", accelerators)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly {
    override val accelerators: Optional[
      List[zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingAccelerator.wrap(item)
        }.toList
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly =
    new Wrapper(impl)
}
