package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorAttributesRequest(
    acceleratorArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest = {
    import DescribeAcceleratorAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeAcceleratorAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesRequest =
      zio.aws.globalaccelerator.model
        .DescribeAcceleratorAttributesRequest(acceleratorArn)
    def acceleratorArn: GenericString
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest
  ) extends zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest
  ): zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
