package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingEndpointGroupsResponse(
    endpointGroups: Optional[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup]
    ] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse = {
    import ListCustomRoutingEndpointGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
      .builder()
      .optionallyWith(
        endpointGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingEndpointGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse =
      zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse(
        endpointGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def endpointGroups: Optional[
      List[zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly]
    ]
    def nextToken: Optional[GenericString]
    def getEndpointGroups: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointGroups", endpointGroups)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly {
    override val endpointGroups: Optional[
      List[zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.wrap(item)
        }.toList
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
