package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DestinationPortMapping(
    acceleratorArn: Optional[GenericString] = Optional.Absent,
    acceleratorSocketAddresses: Optional[
      Iterable[zio.aws.globalaccelerator.model.SocketAddress]
    ] = Optional.Absent,
    endpointGroupArn: Optional[GenericString] = Optional.Absent,
    endpointId: Optional[GenericString] = Optional.Absent,
    endpointGroupRegion: Optional[GenericString] = Optional.Absent,
    destinationSocketAddress: Optional[
      zio.aws.globalaccelerator.model.SocketAddress
    ] = Optional.Absent,
    ipAddressType: Optional[zio.aws.globalaccelerator.model.IpAddressType] =
      Optional.Absent,
    destinationTrafficState: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping = {
    import DestinationPortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
      .builder()
      .optionallyWith(acceleratorArn.map(value => value: java.lang.String))(
        _.acceleratorArn
      )
      .optionallyWith(
        acceleratorSocketAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acceleratorSocketAddresses)
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .optionallyWith(
        endpointGroupRegion.map(value => value: java.lang.String)
      )(_.endpointGroupRegion)
      .optionallyWith(
        destinationSocketAddress.map(value => value.buildAwsValue())
      )(_.destinationSocketAddress)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(destinationTrafficState.map(value => value.unwrap))(
        _.destinationTrafficState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly =
    zio.aws.globalaccelerator.model.DestinationPortMapping.wrap(buildAwsValue())
}
object DestinationPortMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DestinationPortMapping =
      zio.aws.globalaccelerator.model.DestinationPortMapping(
        acceleratorArn.map(value => value),
        acceleratorSocketAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endpointGroupArn.map(value => value),
        endpointId.map(value => value),
        endpointGroupRegion.map(value => value),
        destinationSocketAddress.map(value => value.asEditable),
        ipAddressType.map(value => value),
        destinationTrafficState.map(value => value)
      )
    def acceleratorArn: Optional[GenericString]
    def acceleratorSocketAddresses
        : Optional[List[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]]
    def endpointGroupArn: Optional[GenericString]
    def endpointId: Optional[GenericString]
    def endpointGroupRegion: Optional[GenericString]
    def destinationSocketAddress
        : Optional[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]
    def ipAddressType: Optional[zio.aws.globalaccelerator.model.IpAddressType]
    def destinationTrafficState: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ]
    def getAcceleratorArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("acceleratorArn", acceleratorArn)
    def getAcceleratorSocketAddresses: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.SocketAddress.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "acceleratorSocketAddresses",
      acceleratorSocketAddresses
    )
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getEndpointGroupRegion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupRegion", endpointGroupRegion)
    def getDestinationSocketAddress: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.SocketAddress.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationSocketAddress",
      destinationSocketAddress
    )
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getDestinationTrafficState: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = AwsError.unwrapOptionField(
      "destinationTrafficState",
      destinationTrafficState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
  ) extends zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly {
    override val acceleratorArn: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorArn())
      .map(value => value: GenericString)
    override val acceleratorSocketAddresses: Optional[
      List[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorSocketAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.SocketAddress.wrap(item)
        }.toList
      )
    override val endpointGroupArn: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroupArn())
        .map(value => value: GenericString)
    override val endpointId: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => value: GenericString)
    override val endpointGroupRegion: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroupRegion())
        .map(value => value: GenericString)
    override val destinationSocketAddress
        : Optional[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationSocketAddress())
        .map(value => zio.aws.globalaccelerator.model.SocketAddress.wrap(value))
    override val ipAddressType
        : Optional[zio.aws.globalaccelerator.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.globalaccelerator.model.IpAddressType.wrap(value))
    override val destinationTrafficState: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationTrafficState())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
  ): zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly =
    new Wrapper(impl)
}
