package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class Listener(
    listenerArn: Optional[GenericString] = Optional.Absent,
    portRanges: Optional[Iterable[zio.aws.globalaccelerator.model.PortRange]] =
      Optional.Absent,
    protocol: Optional[zio.aws.globalaccelerator.model.Protocol] =
      Optional.Absent,
    clientAffinity: Optional[zio.aws.globalaccelerator.model.ClientAffinity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.Listener = {
    import Listener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.Listener
      .builder()
      .optionallyWith(listenerArn.map(value => value: java.lang.String))(
        _.listenerArn
      )
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(clientAffinity.map(value => value.unwrap))(
        _.clientAffinity
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.Listener.ReadOnly =
    zio.aws.globalaccelerator.model.Listener.wrap(buildAwsValue())
}
object Listener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.Listener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.Listener =
      zio.aws.globalaccelerator.model.Listener(
        listenerArn.map(value => value),
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocol.map(value => value),
        clientAffinity.map(value => value)
      )
    def listenerArn: Optional[GenericString]
    def portRanges
        : Optional[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]]
    def protocol: Optional[zio.aws.globalaccelerator.model.Protocol]
    def clientAffinity: Optional[zio.aws.globalaccelerator.model.ClientAffinity]
    def getListenerArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("listenerArn", listenerArn)
    def getPortRanges: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("portRanges", portRanges)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getClientAffinity
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.ClientAffinity] =
      AwsError.unwrapOptionField("clientAffinity", clientAffinity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Listener
  ) extends zio.aws.globalaccelerator.model.Listener.ReadOnly {
    override val listenerArn: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerArn())
      .map(value => value: GenericString)
    override val portRanges
        : Optional[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.PortRange.wrap(item)
          }.toList
        )
    override val protocol: Optional[zio.aws.globalaccelerator.model.Protocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.globalaccelerator.model.Protocol.wrap(value))
    override val clientAffinity
        : Optional[zio.aws.globalaccelerator.model.ClientAffinity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientAffinity())
        .map(value =>
          zio.aws.globalaccelerator.model.ClientAffinity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Listener
  ): zio.aws.globalaccelerator.model.Listener.ReadOnly = new Wrapper(impl)
}
