package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEndpointGroupResponse(
    endpointGroup: Optional[zio.aws.globalaccelerator.model.EndpointGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse = {
    import DescribeEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse
      .builder()
      .optionallyWith(endpointGroup.map(value => value.buildAwsValue()))(
        _.endpointGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse
      .wrap(buildAwsValue())
}
object DescribeEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse =
      zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse(
        endpointGroup.map(value => value.asEditable)
      )
    def endpointGroup
        : Optional[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly]
    def getEndpointGroup: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
    ] = AwsError.unwrapOptionField("endpointGroup", endpointGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse
  ) extends zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly {
    override val endpointGroup
        : Optional[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroup())
        .map(value => zio.aws.globalaccelerator.model.EndpointGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse
  ): zio.aws.globalaccelerator.model.DescribeEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
