package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.PortNumber
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PortRange(
    fromPort: Optional[PortNumber] = Optional.Absent,
    toPort: Optional[PortNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.PortRange = {
    import PortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.PortRange
      .builder()
      .optionallyWith(fromPort.map(value => PortNumber.unwrap(value): Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => PortNumber.unwrap(value): Integer))(
        _.toPort
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.PortRange.ReadOnly =
    zio.aws.globalaccelerator.model.PortRange.wrap(buildAwsValue())
}
object PortRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.PortRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.PortRange =
      zio.aws.globalaccelerator.model
        .PortRange(fromPort.map(value => value), toPort.map(value => value))
    def fromPort: Optional[PortNumber]
    def toPort: Optional[PortNumber]
    def getFromPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("toPort", toPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortRange
  ) extends zio.aws.globalaccelerator.model.PortRange.ReadOnly {
    override val fromPort: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
    override val toPort: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortRange
  ): zio.aws.globalaccelerator.model.PortRange.ReadOnly = new Wrapper(impl)
}
