package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{IpAddress, GenericString}
import scala.jdk.CollectionConverters._
final case class IpSet(
    ipFamily: Optional[GenericString] = Optional.Absent,
    ipAddresses: Optional[Iterable[IpAddress]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.IpSet = {
    import IpSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.IpSet
      .builder()
      .optionallyWith(ipFamily.map(value => value: java.lang.String))(
        _.ipFamily
      )
      .optionallyWith(
        ipAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipAddresses)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.IpSet.ReadOnly =
    zio.aws.globalaccelerator.model.IpSet.wrap(buildAwsValue())
}
object IpSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.IpSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.IpSet =
      zio.aws.globalaccelerator.model
        .IpSet(ipFamily.map(value => value), ipAddresses.map(value => value))
    def ipFamily: Optional[GenericString]
    def ipAddresses: Optional[List[IpAddress]]
    def getIpFamily: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("ipFamily", ipFamily)
    def getIpAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("ipAddresses", ipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.IpSet
  ) extends zio.aws.globalaccelerator.model.IpSet.ReadOnly {
    override val ipFamily: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipFamily())
      .map(value => value: GenericString)
    override val ipAddresses: Optional[List[IpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.primitives.IpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.IpSet
  ): zio.aws.globalaccelerator.model.IpSet.ReadOnly = new Wrapper(impl)
}
