package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeCustomRoutingAcceleratorAttributesRequest(
    acceleratorArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest = {
    import DescribeCustomRoutingAcceleratorAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeCustomRoutingAcceleratorAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest =
      zio.aws.globalaccelerator.model
        .DescribeCustomRoutingAcceleratorAttributesRequest(acceleratorArn)
    def acceleratorArn: GenericString
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest
  ) extends zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest
  ): zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
