package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorResponse(
    accelerator: Optional[zio.aws.globalaccelerator.model.Accelerator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse = {
    import DescribeAcceleratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse
      .builder()
      .optionallyWith(accelerator.map(value => value.buildAwsValue()))(
        _.accelerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeAcceleratorResponse
      .wrap(buildAwsValue())
}
object DescribeAcceleratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeAcceleratorResponse =
      zio.aws.globalaccelerator.model
        .DescribeAcceleratorResponse(accelerator.map(value => value.asEditable))
    def accelerator
        : Optional[zio.aws.globalaccelerator.model.Accelerator.ReadOnly]
    def getAccelerator: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Accelerator.ReadOnly
    ] = AwsError.unwrapOptionField("accelerator", accelerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse
  ) extends zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly {
    override val accelerator
        : Optional[zio.aws.globalaccelerator.model.Accelerator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accelerator())
        .map(value => zio.aws.globalaccelerator.model.Accelerator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse
  ): zio.aws.globalaccelerator.model.DescribeAcceleratorResponse.ReadOnly =
    new Wrapper(impl)
}
