package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ByoipCidr(
    cidr: Optional[GenericString] = Optional.Absent,
    state: Optional[zio.aws.globalaccelerator.model.ByoipCidrState] =
      Optional.Absent,
    events: Optional[Iterable[zio.aws.globalaccelerator.model.ByoipCidrEvent]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr = {
    import ByoipCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly =
    zio.aws.globalaccelerator.model.ByoipCidr.wrap(buildAwsValue())
}
object ByoipCidr {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ByoipCidr =
      zio.aws.globalaccelerator.model.ByoipCidr(
        cidr.map(value => value),
        state.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cidr: Optional[GenericString]
    def state: Optional[zio.aws.globalaccelerator.model.ByoipCidrState]
    def events: Optional[
      List[zio.aws.globalaccelerator.model.ByoipCidrEvent.ReadOnly]
    ]
    def getCidr: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getState
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.ByoipCidrState] =
      AwsError.unwrapOptionField("state", state)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.ByoipCidrEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr
  ) extends zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly {
    override val cidr: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: GenericString)
    override val state
        : Optional[zio.aws.globalaccelerator.model.ByoipCidrState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.globalaccelerator.model.ByoipCidrState.wrap(value)
        )
    override val events: Optional[
      List[zio.aws.globalaccelerator.model.ByoipCidrEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.ByoipCidrEvent.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr
  ): zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly = new Wrapper(impl)
}
