package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{
  PortMappingsMaxResults,
  GenericString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingPortMappingsRequest(
    acceleratorArn: GenericString,
    endpointGroupArn: Optional[GenericString] = Optional.Absent,
    maxResults: Optional[PortMappingsMaxResults] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest = {
    import ListCustomRoutingPortMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .optionallyWith(
        maxResults.map(value => PortMappingsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
      .wrap(buildAwsValue())
}
object ListCustomRoutingPortMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest =
      zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest(
        acceleratorArn,
        endpointGroupArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def acceleratorArn: GenericString
    def endpointGroupArn: Optional[GenericString]
    def maxResults: Optional[PortMappingsMaxResults]
    def nextToken: Optional[GenericString]
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getMaxResults: ZIO[Any, AwsError, PortMappingsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
    override val endpointGroupArn: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroupArn())
        .map(value => value: GenericString)
    override val maxResults: Optional[PortMappingsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.globalaccelerator.model.primitives
            .PortMappingsMaxResults(value)
        )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
  ): zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest.ReadOnly =
    new Wrapper(impl)
}
