package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait CustomRoutingProtocol {
  def unwrap: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol
}
object CustomRoutingProtocol {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol
  ): zio.aws.globalaccelerator.model.CustomRoutingProtocol = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol.UDP =>
      val r = UDP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.CustomRoutingProtocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP
      extends zio.aws.globalaccelerator.model.CustomRoutingProtocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol.TCP
  }
  case object UDP
      extends zio.aws.globalaccelerator.model.CustomRoutingProtocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol.UDP
  }
}
