package zio.aws.globalaccelerator
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.globalaccelerator.model.primitives.{
  TagKey,
  GenericString,
  PortNumber,
  IpAddress
}
import zio.aws.globalaccelerator.model.primitives.ThresholdCount.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object EndpointWeight extends Subtype[Int]
    type EndpointWeight =
      zio.aws.globalaccelerator.model.primitives.EndpointWeight.Type
    type GenericBoolean = Boolean
    type GenericString = String
    object HealthCheckIntervalSeconds extends Subtype[Int]
    type HealthCheckIntervalSeconds =
      zio.aws.globalaccelerator.model.primitives.HealthCheckIntervalSeconds.Type
    object HealthCheckPath extends Subtype[String]
    type HealthCheckPath =
      zio.aws.globalaccelerator.model.primitives.HealthCheckPath.Type
    object HealthCheckPort extends Subtype[Int]
    type HealthCheckPort =
      zio.aws.globalaccelerator.model.primitives.HealthCheckPort.Type
    object IdempotencyToken extends Subtype[String]
    type IdempotencyToken =
      zio.aws.globalaccelerator.model.primitives.IdempotencyToken.Type
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.globalaccelerator.model.primitives.IpAddress.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.globalaccelerator.model.primitives.MaxResults.Type
    object PortMappingsMaxResults extends Subtype[Int]
    type PortMappingsMaxResults =
      zio.aws.globalaccelerator.model.primitives.PortMappingsMaxResults.Type
    object PortNumber extends Subtype[Int]
    type PortNumber = zio.aws.globalaccelerator.model.primitives.PortNumber.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn =
      zio.aws.globalaccelerator.model.primitives.ResourceArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.globalaccelerator.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.globalaccelerator.model.primitives.TagValue.Type
    object ThresholdCount extends Subtype[Int]
    type ThresholdCount =
      zio.aws.globalaccelerator.model.primitives.ThresholdCount.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.globalaccelerator.model.primitives.Timestamp.Type
    object TrafficDialPercentage extends Subtype[Float]
    type TrafficDialPercentage =
      zio.aws.globalaccelerator.model.primitives.TrafficDialPercentage.Type
  }
  type Accelerators = List[zio.aws.globalaccelerator.model.Accelerator]
  type ByoipCidrEvents = List[zio.aws.globalaccelerator.model.ByoipCidrEvent]
  type ByoipCidrs = List[zio.aws.globalaccelerator.model.ByoipCidr]
  type CustomRoutingAccelerators =
    List[zio.aws.globalaccelerator.model.CustomRoutingAccelerator]
  type CustomRoutingDestinationConfigurations =
    List[zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration]
  type CustomRoutingDestinationDescriptions =
    List[zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription]
  type CustomRoutingEndpointConfigurations =
    List[zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration]
  type CustomRoutingEndpointDescriptions =
    List[zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription]
  type CustomRoutingEndpointGroups =
    List[zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup]
  type CustomRoutingListeners =
    List[zio.aws.globalaccelerator.model.CustomRoutingListener]
  type CustomRoutingProtocols =
    List[zio.aws.globalaccelerator.model.CustomRoutingProtocol]
  type DestinationAddresses = List[IpAddress]
  type DestinationPortMappings =
    List[zio.aws.globalaccelerator.model.DestinationPortMapping]
  type DestinationPorts = List[PortNumber]
  type EndpointConfigurations =
    List[zio.aws.globalaccelerator.model.EndpointConfiguration]
  type EndpointDescriptions =
    List[zio.aws.globalaccelerator.model.EndpointDescription]
  type EndpointGroups = List[zio.aws.globalaccelerator.model.EndpointGroup]
  type EndpointIds = List[GenericString]
  type IpAddresses = List[IpAddress]
  type IpSets = List[zio.aws.globalaccelerator.model.IpSet]
  type Listeners = List[zio.aws.globalaccelerator.model.Listener]
  type PortMappings = List[zio.aws.globalaccelerator.model.PortMapping]
  type PortOverrides = List[zio.aws.globalaccelerator.model.PortOverride]
  type PortRanges = List[zio.aws.globalaccelerator.model.PortRange]
  type Protocols = List[zio.aws.globalaccelerator.model.Protocol]
  type SocketAddresses = List[zio.aws.globalaccelerator.model.SocketAddress]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.globalaccelerator.model.Tag]
}
