package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAcceleratorResponse(
    accelerator: Optional[zio.aws.globalaccelerator.model.Accelerator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse = {
    import CreateAcceleratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse
      .builder()
      .optionallyWith(accelerator.map(value => value.buildAwsValue()))(
        _.accelerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly =
    zio.aws.globalaccelerator.model.CreateAcceleratorResponse
      .wrap(buildAwsValue())
}
object CreateAcceleratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CreateAcceleratorResponse =
      zio.aws.globalaccelerator.model
        .CreateAcceleratorResponse(accelerator.map(value => value.asEditable))
    def accelerator
        : Optional[zio.aws.globalaccelerator.model.Accelerator.ReadOnly]
    def getAccelerator: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Accelerator.ReadOnly
    ] = AwsError.unwrapOptionField("accelerator", accelerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse
  ) extends zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly {
    override val accelerator
        : Optional[zio.aws.globalaccelerator.model.Accelerator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accelerator())
        .map(value => zio.aws.globalaccelerator.model.Accelerator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse
  ): zio.aws.globalaccelerator.model.CreateAcceleratorResponse.ReadOnly =
    new Wrapper(impl)
}
