package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait ByoipCidrState {
  def unwrap
      : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState
}
object ByoipCidrState {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState
  ): zio.aws.globalaccelerator.model.ByoipCidrState = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_PROVISIONING =>
      val r = PENDING_PROVISIONING
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_ADVERTISING =>
      val r = PENDING_ADVERTISING
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.ADVERTISING =>
      val r = ADVERTISING
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_WITHDRAWING =>
      val r = PENDING_WITHDRAWING
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_DEPROVISIONING =>
      val r = PENDING_DEPROVISIONING
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.DEPROVISIONED =>
      val r = DEPROVISIONED
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_PROVISION =>
      val r = FAILED_PROVISION
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_ADVERTISING =>
      val r = FAILED_ADVERTISING
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_WITHDRAW =>
      val r = FAILED_WITHDRAW
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_DEPROVISION =>
      val r = FAILED_DEPROVISION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_PROVISIONING
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_PROVISIONING
  }
  case object READY extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.READY
  }
  case object PENDING_ADVERTISING
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_ADVERTISING
  }
  case object ADVERTISING
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.ADVERTISING
  }
  case object PENDING_WITHDRAWING
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_WITHDRAWING
  }
  case object PENDING_DEPROVISIONING
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.PENDING_DEPROVISIONING
  }
  case object DEPROVISIONED
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.DEPROVISIONED
  }
  case object FAILED_PROVISION
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_PROVISION
  }
  case object FAILED_ADVERTISING
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_ADVERTISING
  }
  case object FAILED_WITHDRAW
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_WITHDRAW
  }
  case object FAILED_DEPROVISION
      extends zio.aws.globalaccelerator.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState =
      software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState.FAILED_DEPROVISION
  }
}
