package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class UpdateListenerRequest(
    listenerArn: GenericString,
    portRanges: Option[Iterable[zio.aws.globalaccelerator.model.PortRange]] =
      None,
    protocol: Option[zio.aws.globalaccelerator.model.Protocol] = None,
    clientAffinity: Option[zio.aws.globalaccelerator.model.ClientAffinity] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest = {
    import UpdateListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest
      .builder()
      .listenerArn(listenerArn: java.lang.String)
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(clientAffinity.map(value => value.unwrap))(
        _.clientAffinity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateListenerRequest.wrap(buildAwsValue())
}
object UpdateListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.UpdateListenerRequest =
      zio.aws.globalaccelerator.model.UpdateListenerRequest(
        listenerArn,
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocol.map(value => value),
        clientAffinity.map(value => value)
      )
    def listenerArn: GenericString
    def portRanges
        : Option[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]]
    def protocol: Option[zio.aws.globalaccelerator.model.Protocol]
    def clientAffinity: Option[zio.aws.globalaccelerator.model.ClientAffinity]
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
    def getPortRanges: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("portRanges", portRanges)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getClientAffinity
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.ClientAffinity] =
      AwsError.unwrapOptionField("clientAffinity", clientAffinity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest
  ) extends zio.aws.globalaccelerator.model.UpdateListenerRequest.ReadOnly {
    override val listenerArn: GenericString = impl.listenerArn(): GenericString
    override val portRanges
        : Option[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]] =
      scala
        .Option(impl.portRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.PortRange.wrap(item)
          }.toList
        )
    override val protocol: Option[zio.aws.globalaccelerator.model.Protocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.globalaccelerator.model.Protocol.wrap(value))
    override val clientAffinity
        : Option[zio.aws.globalaccelerator.model.ClientAffinity] = scala
      .Option(impl.clientAffinity())
      .map(value => zio.aws.globalaccelerator.model.ClientAffinity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest
  ): zio.aws.globalaccelerator.model.UpdateListenerRequest.ReadOnly =
    new Wrapper(impl)
}
