package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  PortMappingsMaxResults,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingPortMappingsByDestinationRequest(
    endpointId: GenericString,
    destinationAddress: GenericString,
    maxResults: Option[PortMappingsMaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest = {
    import ListCustomRoutingPortMappingsByDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
      .builder()
      .endpointId(endpointId: java.lang.String)
      .destinationAddress(destinationAddress: java.lang.String)
      .optionallyWith(
        maxResults.map(value => PortMappingsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
      .wrap(buildAwsValue())
}
object ListCustomRoutingPortMappingsByDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest =
      zio.aws.globalaccelerator.model
        .ListCustomRoutingPortMappingsByDestinationRequest(
          endpointId,
          destinationAddress,
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def endpointId: GenericString
    def destinationAddress: GenericString
    def maxResults: Option[PortMappingsMaxResults]
    def nextToken: Option[GenericString]
    def getEndpointId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointId)
    def getDestinationAddress: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(destinationAddress)
    def getMaxResults: ZIO[Any, AwsError, PortMappingsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest.ReadOnly {
    override val endpointId: GenericString = impl.endpointId(): GenericString
    override val destinationAddress: GenericString =
      impl.destinationAddress(): GenericString
    override val maxResults: Option[PortMappingsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortMappingsMaxResults(value)
      )
    override val nextToken: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
  ): zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
