package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAcceleratorAttributesResponse(
    acceleratorAttributes: Option[
      zio.aws.globalaccelerator.model.AcceleratorAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse = {
    import UpdateAcceleratorAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse
      .builder()
      .optionallyWith(
        acceleratorAttributes.map(value => value.buildAwsValue())
      )(_.acceleratorAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse
      .wrap(buildAwsValue())
}
object UpdateAcceleratorAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse =
      zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse(
        acceleratorAttributes.map(value => value.asEditable)
      )
    def acceleratorAttributes
        : Option[zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly]
    def getAcceleratorAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("acceleratorAttributes", acceleratorAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse
  ) extends zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly {
    override val acceleratorAttributes: Option[
      zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly
    ] = scala
      .Option(impl.acceleratorAttributes())
      .map(value =>
        zio.aws.globalaccelerator.model.AcceleratorAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse
  ): zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
