package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class Listener(
    listenerArn: Option[GenericString] = None,
    portRanges: Option[Iterable[zio.aws.globalaccelerator.model.PortRange]] =
      None,
    protocol: Option[zio.aws.globalaccelerator.model.Protocol] = None,
    clientAffinity: Option[zio.aws.globalaccelerator.model.ClientAffinity] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.Listener = {
    import Listener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.Listener
      .builder()
      .optionallyWith(listenerArn.map(value => value: java.lang.String))(
        _.listenerArn
      )
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(clientAffinity.map(value => value.unwrap))(
        _.clientAffinity
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.Listener.ReadOnly =
    zio.aws.globalaccelerator.model.Listener.wrap(buildAwsValue())
}
object Listener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.Listener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.Listener =
      zio.aws.globalaccelerator.model.Listener(
        listenerArn.map(value => value),
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocol.map(value => value),
        clientAffinity.map(value => value)
      )
    def listenerArn: Option[GenericString]
    def portRanges
        : Option[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]]
    def protocol: Option[zio.aws.globalaccelerator.model.Protocol]
    def clientAffinity: Option[zio.aws.globalaccelerator.model.ClientAffinity]
    def getListenerArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("listenerArn", listenerArn)
    def getPortRanges: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("portRanges", portRanges)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getClientAffinity
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.ClientAffinity] =
      AwsError.unwrapOptionField("clientAffinity", clientAffinity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Listener
  ) extends zio.aws.globalaccelerator.model.Listener.ReadOnly {
    override val listenerArn: Option[GenericString] =
      scala.Option(impl.listenerArn()).map(value => value: GenericString)
    override val portRanges
        : Option[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]] =
      scala
        .Option(impl.portRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.PortRange.wrap(item)
          }.toList
        )
    override val protocol: Option[zio.aws.globalaccelerator.model.Protocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.globalaccelerator.model.Protocol.wrap(value))
    override val clientAffinity
        : Option[zio.aws.globalaccelerator.model.ClientAffinity] = scala
      .Option(impl.clientAffinity())
      .map(value => zio.aws.globalaccelerator.model.ClientAffinity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Listener
  ): zio.aws.globalaccelerator.model.Listener.ReadOnly = new Wrapper(impl)
}
