package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait HealthState {
  def unwrap
      : software.amazon.awssdk.services.globalaccelerator.model.HealthState
}
object HealthState {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.HealthState
  ): zio.aws.globalaccelerator.model.HealthState = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.HealthState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.HealthState.INITIAL =>
      val r = INITIAL
      r
    case software.amazon.awssdk.services.globalaccelerator.model.HealthState.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.globalaccelerator.model.HealthState.UNHEALTHY =>
      val r = UNHEALTHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.HealthState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthState =
      software.amazon.awssdk.services.globalaccelerator.model.HealthState.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIAL extends zio.aws.globalaccelerator.model.HealthState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthState =
      software.amazon.awssdk.services.globalaccelerator.model.HealthState.INITIAL
  }
  case object HEALTHY extends zio.aws.globalaccelerator.model.HealthState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthState =
      software.amazon.awssdk.services.globalaccelerator.model.HealthState.HEALTHY
  }
  case object UNHEALTHY extends zio.aws.globalaccelerator.model.HealthState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthState =
      software.amazon.awssdk.services.globalaccelerator.model.HealthState.UNHEALTHY
  }
}
