package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait CustomRoutingDestinationTrafficState {
  def unwrap: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState
}
object CustomRoutingDestinationTrafficState {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState
  ): zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState =
    value match {
      case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState.ALLOW =>
        val r = ALLOW
        r
      case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState.DENY =>
        val r = DENY
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW
      extends zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState.ALLOW
  }
  case object DENY
      extends zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState.DENY
  }
}
