package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{GenericString, PortNumber}
import scala.jdk.CollectionConverters._
final case class PortMapping(
    acceleratorPort: Option[PortNumber] = None,
    endpointGroupArn: Option[GenericString] = None,
    endpointId: Option[GenericString] = None,
    destinationSocketAddress: Option[
      zio.aws.globalaccelerator.model.SocketAddress
    ] = None,
    protocols: Option[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingProtocol]
    ] = None,
    destinationTrafficState: Option[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.PortMapping = {
    import PortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.PortMapping
      .builder()
      .optionallyWith(
        acceleratorPort.map(value => PortNumber.unwrap(value): Integer)
      )(_.acceleratorPort)
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .optionallyWith(
        destinationSocketAddress.map(value => value.buildAwsValue())
      )(_.destinationSocketAddress)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(destinationTrafficState.map(value => value.unwrap))(
        _.destinationTrafficState
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.PortMapping.ReadOnly =
    zio.aws.globalaccelerator.model.PortMapping.wrap(buildAwsValue())
}
object PortMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.PortMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.PortMapping =
      zio.aws.globalaccelerator.model.PortMapping(
        acceleratorPort.map(value => value),
        endpointGroupArn.map(value => value),
        endpointId.map(value => value),
        destinationSocketAddress.map(value => value.asEditable),
        protocols.map(value => value),
        destinationTrafficState.map(value => value)
      )
    def acceleratorPort: Option[PortNumber]
    def endpointGroupArn: Option[GenericString]
    def endpointId: Option[GenericString]
    def destinationSocketAddress
        : Option[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]
    def protocols
        : Option[List[zio.aws.globalaccelerator.model.CustomRoutingProtocol]]
    def destinationTrafficState: Option[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ]
    def getAcceleratorPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("acceleratorPort", acceleratorPort)
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getDestinationSocketAddress: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.SocketAddress.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationSocketAddress",
      destinationSocketAddress
    )
    def getProtocols: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingProtocol
    ]] = AwsError.unwrapOptionField("protocols", protocols)
    def getDestinationTrafficState: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = AwsError.unwrapOptionField(
      "destinationTrafficState",
      destinationTrafficState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortMapping
  ) extends zio.aws.globalaccelerator.model.PortMapping.ReadOnly {
    override val acceleratorPort: Option[PortNumber] = scala
      .Option(impl.acceleratorPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
    override val endpointGroupArn: Option[GenericString] =
      scala.Option(impl.endpointGroupArn()).map(value => value: GenericString)
    override val endpointId: Option[GenericString] =
      scala.Option(impl.endpointId()).map(value => value: GenericString)
    override val destinationSocketAddress
        : Option[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly] = scala
      .Option(impl.destinationSocketAddress())
      .map(value => zio.aws.globalaccelerator.model.SocketAddress.wrap(value))
    override val protocols
        : Option[List[zio.aws.globalaccelerator.model.CustomRoutingProtocol]] =
      scala
        .Option(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.CustomRoutingProtocol.wrap(item)
          }.toList
        )
    override val destinationTrafficState: Option[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = scala
      .Option(impl.destinationTrafficState())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortMapping
  ): zio.aws.globalaccelerator.model.PortMapping.ReadOnly = new Wrapper(impl)
}
