package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{MaxResults, GenericString}
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingEndpointGroupsRequest(
    listenerArn: GenericString,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest = {
    import ListCustomRoutingEndpointGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
      .builder()
      .listenerArn(listenerArn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
      .wrap(buildAwsValue())
}
object ListCustomRoutingEndpointGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest =
      zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest(
        listenerArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def listenerArn: GenericString
    def maxResults: Option[MaxResults]
    def nextToken: Option[GenericString]
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest.ReadOnly {
    override val listenerArn: GenericString = impl.listenerArn(): GenericString
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
  ): zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
