package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListAcceleratorsResponse(
    accelerators: Option[
      Iterable[zio.aws.globalaccelerator.model.Accelerator]
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse = {
    import ListAcceleratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse
      .builder()
      .optionallyWith(
        accelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accelerators)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListAcceleratorsResponse
      .wrap(buildAwsValue())
}
object ListAcceleratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ListAcceleratorsResponse =
      zio.aws.globalaccelerator.model.ListAcceleratorsResponse(
        accelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accelerators
        : Option[List[zio.aws.globalaccelerator.model.Accelerator.ReadOnly]]
    def nextToken: Option[GenericString]
    def getAccelerators: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Accelerator.ReadOnly
    ]] = AwsError.unwrapOptionField("accelerators", accelerators)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse
  ) extends zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly {
    override val accelerators
        : Option[List[zio.aws.globalaccelerator.model.Accelerator.ReadOnly]] =
      scala
        .Option(impl.accelerators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Accelerator.wrap(item)
          }.toList
        )
    override val nextToken: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse
  ): zio.aws.globalaccelerator.model.ListAcceleratorsResponse.ReadOnly =
    new Wrapper(impl)
}
