package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CustomRoutingEndpointGroup(
    endpointGroupArn: Option[GenericString] = None,
    endpointGroupRegion: Option[GenericString] = None,
    destinationDescriptions: Option[Iterable[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription
    ]] = None,
    endpointDescriptions: Option[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup = {
    import CustomRoutingEndpointGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
      .builder()
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .optionallyWith(
        endpointGroupRegion.map(value => value: java.lang.String)
      )(_.endpointGroupRegion)
      .optionallyWith(
        destinationDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationDescriptions)
      .optionallyWith(
        endpointDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup
      .wrap(buildAwsValue())
}
object CustomRoutingEndpointGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup =
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup(
        endpointGroupArn.map(value => value),
        endpointGroupRegion.map(value => value),
        destinationDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endpointDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def endpointGroupArn: Option[GenericString]
    def endpointGroupRegion: Option[GenericString]
    def destinationDescriptions: Option[List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly
    ]]
    def endpointDescriptions: Option[List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]]
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getEndpointGroupRegion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupRegion", endpointGroupRegion)
    def getDestinationDescriptions: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "destinationDescriptions",
      destinationDescriptions
    )
    def getEndpointDescriptions: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("endpointDescriptions", endpointDescriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
  ) extends zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly {
    override val endpointGroupArn: Option[GenericString] =
      scala.Option(impl.endpointGroupArn()).map(value => value: GenericString)
    override val endpointGroupRegion: Option[GenericString] = scala
      .Option(impl.endpointGroupRegion())
      .map(value => value: GenericString)
    override val destinationDescriptions: Option[List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly
    ]] = scala
      .Option(impl.destinationDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription
            .wrap(item)
        }.toList
      )
    override val endpointDescriptions: Option[List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]] = scala
      .Option(impl.endpointDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
  ): zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly =
    new Wrapper(impl)
}
