package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  IdempotencyToken,
  GenericBoolean,
  IpAddress,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class CreateAcceleratorRequest(
    name: GenericString,
    ipAddressType: Option[zio.aws.globalaccelerator.model.IpAddressType] = None,
    ipAddresses: Option[Iterable[IpAddress]] = None,
    enabled: Option[GenericBoolean] = None,
    idempotencyToken: IdempotencyToken,
    tags: Option[Iterable[zio.aws.globalaccelerator.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest = {
    import CreateAcceleratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        ipAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipAddresses)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateAcceleratorRequest.ReadOnly =
    zio.aws.globalaccelerator.model.CreateAcceleratorRequest
      .wrap(buildAwsValue())
}
object CreateAcceleratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CreateAcceleratorRequest =
      zio.aws.globalaccelerator.model.CreateAcceleratorRequest(
        name,
        ipAddressType.map(value => value),
        ipAddresses.map(value => value),
        enabled.map(value => value),
        idempotencyToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: GenericString
    def ipAddressType: Option[zio.aws.globalaccelerator.model.IpAddressType]
    def ipAddresses: Option[List[IpAddress]]
    def enabled: Option[GenericBoolean]
    def idempotencyToken: IdempotencyToken
    def tags: Option[List[zio.aws.globalaccelerator.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, GenericString] = ZIO.succeed(name)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getIpAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("ipAddresses", ipAddresses)
    def getEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest
  ) extends zio.aws.globalaccelerator.model.CreateAcceleratorRequest.ReadOnly {
    override val name: GenericString = impl.name(): GenericString
    override val ipAddressType
        : Option[zio.aws.globalaccelerator.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value => zio.aws.globalaccelerator.model.IpAddressType.wrap(value))
    override val ipAddresses: Option[List[IpAddress]] = scala
      .Option(impl.ipAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.primitives.IpAddress(item)
        }.toList
      )
    override val enabled: Option[GenericBoolean] =
      scala.Option(impl.enabled()).map(value => value: GenericBoolean)
    override val idempotencyToken: IdempotencyToken =
      zio.aws.globalaccelerator.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
    override val tags
        : Option[List[zio.aws.globalaccelerator.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest
  ): zio.aws.globalaccelerator.model.CreateAcceleratorRequest.ReadOnly =
    new Wrapper(impl)
}
