package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class UpdateAcceleratorAttributesRequest(
    acceleratorArn: GenericString,
    flowLogsEnabled: Option[GenericBoolean] = None,
    flowLogsS3Bucket: Option[GenericString] = None,
    flowLogsS3Prefix: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest = {
    import UpdateAcceleratorAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .optionallyWith(flowLogsEnabled.map(value => value: java.lang.Boolean))(
        _.flowLogsEnabled
      )
      .optionallyWith(flowLogsS3Bucket.map(value => value: java.lang.String))(
        _.flowLogsS3Bucket
      )
      .optionallyWith(flowLogsS3Prefix.map(value => value: java.lang.String))(
        _.flowLogsS3Prefix
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesRequest.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesRequest
      .wrap(buildAwsValue())
}
object UpdateAcceleratorAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesRequest =
      zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesRequest(
        acceleratorArn,
        flowLogsEnabled.map(value => value),
        flowLogsS3Bucket.map(value => value),
        flowLogsS3Prefix.map(value => value)
      )
    def acceleratorArn: GenericString
    def flowLogsEnabled: Option[GenericBoolean]
    def flowLogsS3Bucket: Option[GenericString]
    def flowLogsS3Prefix: Option[GenericString]
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getFlowLogsEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("flowLogsEnabled", flowLogsEnabled)
    def getFlowLogsS3Bucket: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("flowLogsS3Bucket", flowLogsS3Bucket)
    def getFlowLogsS3Prefix: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("flowLogsS3Prefix", flowLogsS3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest
  ) extends zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
    override val flowLogsEnabled: Option[GenericBoolean] =
      scala.Option(impl.flowLogsEnabled()).map(value => value: GenericBoolean)
    override val flowLogsS3Bucket: Option[GenericString] =
      scala.Option(impl.flowLogsS3Bucket()).map(value => value: GenericString)
    override val flowLogsS3Prefix: Option[GenericString] =
      scala.Option(impl.flowLogsS3Prefix()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest
  ): zio.aws.globalaccelerator.model.UpdateAcceleratorAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
