package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  TrafficDialPercentage,
  GenericString,
  HealthCheckPath,
  HealthCheckIntervalSeconds,
  ThresholdCount,
  HealthCheckPort
}
import scala.jdk.CollectionConverters._
final case class EndpointGroup(
    endpointGroupArn: Option[GenericString] = None,
    endpointGroupRegion: Option[GenericString] = None,
    endpointDescriptions: Option[
      Iterable[zio.aws.globalaccelerator.model.EndpointDescription]
    ] = None,
    trafficDialPercentage: Option[TrafficDialPercentage] = None,
    healthCheckPort: Option[HealthCheckPort] = None,
    healthCheckProtocol: Option[
      zio.aws.globalaccelerator.model.HealthCheckProtocol
    ] = None,
    healthCheckPath: Option[HealthCheckPath] = None,
    healthCheckIntervalSeconds: Option[HealthCheckIntervalSeconds] = None,
    thresholdCount: Option[ThresholdCount] = None,
    portOverrides: Option[
      Iterable[zio.aws.globalaccelerator.model.PortOverride]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup = {
    import EndpointGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup
      .builder()
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .optionallyWith(
        endpointGroupRegion.map(value => value: java.lang.String)
      )(_.endpointGroupRegion)
      .optionallyWith(
        endpointDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointDescriptions)
      .optionallyWith(
        trafficDialPercentage.map(value =>
          TrafficDialPercentage.unwrap(value): java.lang.Float
        )
      )(_.trafficDialPercentage)
      .optionallyWith(
        healthCheckPort.map(value => HealthCheckPort.unwrap(value): Integer)
      )(_.healthCheckPort)
      .optionallyWith(healthCheckProtocol.map(value => value.unwrap))(
        _.healthCheckProtocol
      )
      .optionallyWith(
        healthCheckPath.map(value =>
          HealthCheckPath.unwrap(value): java.lang.String
        )
      )(_.healthCheckPath)
      .optionallyWith(
        healthCheckIntervalSeconds.map(value =>
          HealthCheckIntervalSeconds.unwrap(value): Integer
        )
      )(_.healthCheckIntervalSeconds)
      .optionallyWith(
        thresholdCount.map(value => ThresholdCount.unwrap(value): Integer)
      )(_.thresholdCount)
      .optionallyWith(
        portOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portOverrides)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly =
    zio.aws.globalaccelerator.model.EndpointGroup.wrap(buildAwsValue())
}
object EndpointGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.EndpointGroup =
      zio.aws.globalaccelerator.model.EndpointGroup(
        endpointGroupArn.map(value => value),
        endpointGroupRegion.map(value => value),
        endpointDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trafficDialPercentage.map(value => value),
        healthCheckPort.map(value => value),
        healthCheckProtocol.map(value => value),
        healthCheckPath.map(value => value),
        healthCheckIntervalSeconds.map(value => value),
        thresholdCount.map(value => value),
        portOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def endpointGroupArn: Option[GenericString]
    def endpointGroupRegion: Option[GenericString]
    def endpointDescriptions: Option[
      List[zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly]
    ]
    def trafficDialPercentage: Option[TrafficDialPercentage]
    def healthCheckPort: Option[HealthCheckPort]
    def healthCheckProtocol
        : Option[zio.aws.globalaccelerator.model.HealthCheckProtocol]
    def healthCheckPath: Option[HealthCheckPath]
    def healthCheckIntervalSeconds: Option[HealthCheckIntervalSeconds]
    def thresholdCount: Option[ThresholdCount]
    def portOverrides
        : Option[List[zio.aws.globalaccelerator.model.PortOverride.ReadOnly]]
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getEndpointGroupRegion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupRegion", endpointGroupRegion)
    def getEndpointDescriptions: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("endpointDescriptions", endpointDescriptions)
    def getTrafficDialPercentage: ZIO[Any, AwsError, TrafficDialPercentage] =
      AwsError.unwrapOptionField("trafficDialPercentage", trafficDialPercentage)
    def getHealthCheckPort: ZIO[Any, AwsError, HealthCheckPort] =
      AwsError.unwrapOptionField("healthCheckPort", healthCheckPort)
    def getHealthCheckProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.HealthCheckProtocol
    ] = AwsError.unwrapOptionField("healthCheckProtocol", healthCheckProtocol)
    def getHealthCheckPath: ZIO[Any, AwsError, HealthCheckPath] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPath)
    def getHealthCheckIntervalSeconds
        : ZIO[Any, AwsError, HealthCheckIntervalSeconds] =
      AwsError.unwrapOptionField(
        "healthCheckIntervalSeconds",
        healthCheckIntervalSeconds
      )
    def getThresholdCount: ZIO[Any, AwsError, ThresholdCount] =
      AwsError.unwrapOptionField("thresholdCount", thresholdCount)
    def getPortOverrides: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.PortOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("portOverrides", portOverrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup
  ) extends zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly {
    override val endpointGroupArn: Option[GenericString] =
      scala.Option(impl.endpointGroupArn()).map(value => value: GenericString)
    override val endpointGroupRegion: Option[GenericString] = scala
      .Option(impl.endpointGroupRegion())
      .map(value => value: GenericString)
    override val endpointDescriptions: Option[
      List[zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly]
    ] = scala
      .Option(impl.endpointDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.EndpointDescription.wrap(item)
        }.toList
      )
    override val trafficDialPercentage: Option[TrafficDialPercentage] = scala
      .Option(impl.trafficDialPercentage())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.TrafficDialPercentage(value)
      )
    override val healthCheckPort: Option[HealthCheckPort] = scala
      .Option(impl.healthCheckPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.HealthCheckPort(value)
      )
    override val healthCheckProtocol
        : Option[zio.aws.globalaccelerator.model.HealthCheckProtocol] = scala
      .Option(impl.healthCheckProtocol())
      .map(value =>
        zio.aws.globalaccelerator.model.HealthCheckProtocol.wrap(value)
      )
    override val healthCheckPath: Option[HealthCheckPath] = scala
      .Option(impl.healthCheckPath())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.HealthCheckPath(value)
      )
    override val healthCheckIntervalSeconds
        : Option[HealthCheckIntervalSeconds] = scala
      .Option(impl.healthCheckIntervalSeconds())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives
          .HealthCheckIntervalSeconds(value)
      )
    override val thresholdCount: Option[ThresholdCount] = scala
      .Option(impl.thresholdCount())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.ThresholdCount(value)
      )
    override val portOverrides
        : Option[List[zio.aws.globalaccelerator.model.PortOverride.ReadOnly]] =
      scala
        .Option(impl.portOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.PortOverride.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup
  ): zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly = new Wrapper(impl)
}
