package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  EndpointWeight,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class EndpointDescription(
    endpointId: Option[GenericString] = None,
    weight: Option[EndpointWeight] = None,
    healthState: Option[zio.aws.globalaccelerator.model.HealthState] = None,
    healthReason: Option[GenericString] = None,
    clientIPPreservationEnabled: Option[GenericBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.EndpointDescription = {
    import EndpointDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.EndpointDescription
      .builder()
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .optionallyWith(
        weight.map(value => EndpointWeight.unwrap(value): Integer)
      )(_.weight)
      .optionallyWith(healthState.map(value => value.unwrap))(_.healthState)
      .optionallyWith(healthReason.map(value => value: java.lang.String))(
        _.healthReason
      )
      .optionallyWith(
        clientIPPreservationEnabled.map(value => value: java.lang.Boolean)
      )(_.clientIPPreservationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly =
    zio.aws.globalaccelerator.model.EndpointDescription.wrap(buildAwsValue())
}
object EndpointDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.EndpointDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.EndpointDescription =
      zio.aws.globalaccelerator.model.EndpointDescription(
        endpointId.map(value => value),
        weight.map(value => value),
        healthState.map(value => value),
        healthReason.map(value => value),
        clientIPPreservationEnabled.map(value => value)
      )
    def endpointId: Option[GenericString]
    def weight: Option[EndpointWeight]
    def healthState: Option[zio.aws.globalaccelerator.model.HealthState]
    def healthReason: Option[GenericString]
    def clientIPPreservationEnabled: Option[GenericBoolean]
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getWeight: ZIO[Any, AwsError, EndpointWeight] =
      AwsError.unwrapOptionField("weight", weight)
    def getHealthState
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.HealthState] =
      AwsError.unwrapOptionField("healthState", healthState)
    def getHealthReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("healthReason", healthReason)
    def getClientIPPreservationEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField(
        "clientIPPreservationEnabled",
        clientIPPreservationEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointDescription
  ) extends zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly {
    override val endpointId: Option[GenericString] =
      scala.Option(impl.endpointId()).map(value => value: GenericString)
    override val weight: Option[EndpointWeight] = scala
      .Option(impl.weight())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.EndpointWeight(value)
      )
    override val healthState
        : Option[zio.aws.globalaccelerator.model.HealthState] = scala
      .Option(impl.healthState())
      .map(value => zio.aws.globalaccelerator.model.HealthState.wrap(value))
    override val healthReason: Option[GenericString] =
      scala.Option(impl.healthReason()).map(value => value: GenericString)
    override val clientIPPreservationEnabled: Option[GenericBoolean] = scala
      .Option(impl.clientIPPreservationEnabled())
      .map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointDescription
  ): zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly = new Wrapper(
    impl
  )
}
