package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CustomRoutingEndpointDescription(
    endpointId: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription = {
    import CustomRoutingEndpointDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription
      .builder()
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription
      .wrap(buildAwsValue())
}
object CustomRoutingEndpointDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription =
      zio.aws.globalaccelerator.model
        .CustomRoutingEndpointDescription(endpointId.map(value => value))
    def endpointId: Option[GenericString]
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription
  ) extends zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly {
    override val endpointId: Option[GenericString] =
      scala.Option(impl.endpointId()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription
  ): zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly =
    new Wrapper(impl)
}
