package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.globalaccelerator.model.primitives.{
  Timestamp,
  GenericBoolean,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class Accelerator(
    acceleratorArn: Option[GenericString] = None,
    name: Option[GenericString] = None,
    ipAddressType: Option[zio.aws.globalaccelerator.model.IpAddressType] = None,
    enabled: Option[GenericBoolean] = None,
    ipSets: Option[Iterable[zio.aws.globalaccelerator.model.IpSet]] = None,
    dnsName: Option[GenericString] = None,
    status: Option[zio.aws.globalaccelerator.model.AcceleratorStatus] = None,
    createdTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.Accelerator = {
    import Accelerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.Accelerator
      .builder()
      .optionallyWith(acceleratorArn.map(value => value: java.lang.String))(
        _.acceleratorArn
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        ipSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipSets)
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.Accelerator.ReadOnly =
    zio.aws.globalaccelerator.model.Accelerator.wrap(buildAwsValue())
}
object Accelerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.Accelerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.Accelerator =
      zio.aws.globalaccelerator.model.Accelerator(
        acceleratorArn.map(value => value),
        name.map(value => value),
        ipAddressType.map(value => value),
        enabled.map(value => value),
        ipSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dnsName.map(value => value),
        status.map(value => value),
        createdTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def acceleratorArn: Option[GenericString]
    def name: Option[GenericString]
    def ipAddressType: Option[zio.aws.globalaccelerator.model.IpAddressType]
    def enabled: Option[GenericBoolean]
    def ipSets: Option[List[zio.aws.globalaccelerator.model.IpSet.ReadOnly]]
    def dnsName: Option[GenericString]
    def status: Option[zio.aws.globalaccelerator.model.AcceleratorStatus]
    def createdTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def getAcceleratorArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("acceleratorArn", acceleratorArn)
    def getName: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("name", name)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIpSets: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.IpSet.ReadOnly
    ]] = AwsError.unwrapOptionField("ipSets", ipSets)
    def getDnsName: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.AcceleratorStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Accelerator
  ) extends zio.aws.globalaccelerator.model.Accelerator.ReadOnly {
    override val acceleratorArn: Option[GenericString] =
      scala.Option(impl.acceleratorArn()).map(value => value: GenericString)
    override val name: Option[GenericString] =
      scala.Option(impl.name()).map(value => value: GenericString)
    override val ipAddressType
        : Option[zio.aws.globalaccelerator.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value => zio.aws.globalaccelerator.model.IpAddressType.wrap(value))
    override val enabled: Option[GenericBoolean] =
      scala.Option(impl.enabled()).map(value => value: GenericBoolean)
    override val ipSets
        : Option[List[zio.aws.globalaccelerator.model.IpSet.ReadOnly]] = scala
      .Option(impl.ipSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.IpSet.wrap(item)
        }.toList
      )
    override val dnsName: Option[GenericString] =
      scala.Option(impl.dnsName()).map(value => value: GenericString)
    override val status
        : Option[zio.aws.globalaccelerator.model.AcceleratorStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.globalaccelerator.model.AcceleratorStatus.wrap(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.globalaccelerator.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.globalaccelerator.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Accelerator
  ): zio.aws.globalaccelerator.model.Accelerator.ReadOnly = new Wrapper(impl)
}
