package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAcceleratorResponse(
    accelerator: Option[zio.aws.globalaccelerator.model.Accelerator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse = {
    import UpdateAcceleratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse
      .builder()
      .optionallyWith(accelerator.map(value => value.buildAwsValue()))(
        _.accelerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateAcceleratorResponse
      .wrap(buildAwsValue())
}
object UpdateAcceleratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.UpdateAcceleratorResponse =
      zio.aws.globalaccelerator.model
        .UpdateAcceleratorResponse(accelerator.map(value => value.asEditable))
    def accelerator
        : Option[zio.aws.globalaccelerator.model.Accelerator.ReadOnly]
    def getAccelerator: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Accelerator.ReadOnly
    ] = AwsError.unwrapOptionField("accelerator", accelerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse
  ) extends zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly {
    override val accelerator
        : Option[zio.aws.globalaccelerator.model.Accelerator.ReadOnly] = scala
      .Option(impl.accelerator())
      .map(value => zio.aws.globalaccelerator.model.Accelerator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse
  ): zio.aws.globalaccelerator.model.UpdateAcceleratorResponse.ReadOnly =
    new Wrapper(impl)
}
