package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingListenersResponse(
    listeners: Option[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingListener]
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse = {
    import ListCustomRoutingListenersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse
      .builder()
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingListenersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse =
      zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse(
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def listeners: Option[
      List[zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly]
    ]
    def nextToken: Option[GenericString]
    def getListeners: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
    ]] = AwsError.unwrapOptionField("listeners", listeners)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly {
    override val listeners: Option[
      List[zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly]
    ] = scala
      .Option(impl.listeners())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingListener.wrap(item)
        }.toList
      )
    override val nextToken: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingListenersResponse.ReadOnly =
    new Wrapper(impl)
}
