package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListByoipCidrsResponse(
    byoipCidrs: Option[Iterable[zio.aws.globalaccelerator.model.ByoipCidr]] =
      None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse = {
    import ListByoipCidrsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse
      .builder()
      .optionallyWith(
        byoipCidrs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.byoipCidrs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListByoipCidrsResponse.wrap(buildAwsValue())
}
object ListByoipCidrsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ListByoipCidrsResponse =
      zio.aws.globalaccelerator.model.ListByoipCidrsResponse(
        byoipCidrs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def byoipCidrs
        : Option[List[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly]]
    def nextToken: Option[GenericString]
    def getByoipCidrs: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
    ]] = AwsError.unwrapOptionField("byoipCidrs", byoipCidrs)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse
  ) extends zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly {
    override val byoipCidrs
        : Option[List[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly]] =
      scala
        .Option(impl.byoipCidrs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.ByoipCidr.wrap(item)
          }.toList
        )
    override val nextToken: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse
  ): zio.aws.globalaccelerator.model.ListByoipCidrsResponse.ReadOnly =
    new Wrapper(impl)
}
