package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.PortNumber
import scala.jdk.CollectionConverters._
final case class CustomRoutingDestinationDescription(
    fromPort: Option[PortNumber] = None,
    toPort: Option[PortNumber] = None,
    protocols: Option[Iterable[zio.aws.globalaccelerator.model.Protocol]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription = {
    import CustomRoutingDestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription
      .builder()
      .optionallyWith(fromPort.map(value => PortNumber.unwrap(value): Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => PortNumber.unwrap(value): Integer))(
        _.toPort
      )
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription
      .wrap(buildAwsValue())
}
object CustomRoutingDestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription =
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription(
        fromPort.map(value => value),
        toPort.map(value => value),
        protocols.map(value => value)
      )
    def fromPort: Option[PortNumber]
    def toPort: Option[PortNumber]
    def protocols: Option[List[zio.aws.globalaccelerator.model.Protocol]]
    def getFromPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.globalaccelerator.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription
  ) extends zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly {
    override val fromPort: Option[PortNumber] = scala
      .Option(impl.fromPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
    override val toPort: Option[PortNumber] = scala
      .Option(impl.toPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
    override val protocols
        : Option[List[zio.aws.globalaccelerator.model.Protocol]] = scala
      .Option(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.Protocol.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription
  ): zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly =
    new Wrapper(impl)
}
