package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait AcceleratorStatus {
  def unwrap: software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus
}
object AcceleratorStatus {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus
  ): zio.aws.globalaccelerator.model.AcceleratorStatus = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus.DEPLOYED =>
      val r = DEPLOYED
      r
    case software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.AcceleratorStatus {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus =
      software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPLOYED
      extends zio.aws.globalaccelerator.model.AcceleratorStatus {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus =
      software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus.DEPLOYED
  }
  case object IN_PROGRESS
      extends zio.aws.globalaccelerator.model.AcceleratorStatus {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus =
      software.amazon.awssdk.services.globalaccelerator.model.AcceleratorStatus.IN_PROGRESS
  }
}
