package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{MaxResults, GenericString}
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingListenersRequest(
    acceleratorArn: GenericString,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest = {
    import ListCustomRoutingListenersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingListenersRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingListenersRequest
      .wrap(buildAwsValue())
}
object ListCustomRoutingListenersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingListenersRequest =
      zio.aws.globalaccelerator.model.ListCustomRoutingListenersRequest(
        acceleratorArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def acceleratorArn: GenericString
    def maxResults: Option[MaxResults]
    def nextToken: Option[GenericString]
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingListenersRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest
  ): zio.aws.globalaccelerator.model.ListCustomRoutingListenersRequest.ReadOnly =
    new Wrapper(impl)
}
