package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class AdvertiseByoipCidrRequest(cidr: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest = {
    import AdvertiseByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.AdvertiseByoipCidrRequest.ReadOnly =
    zio.aws.globalaccelerator.model.AdvertiseByoipCidrRequest
      .wrap(buildAwsValue())
}
object AdvertiseByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.AdvertiseByoipCidrRequest =
      zio.aws.globalaccelerator.model.AdvertiseByoipCidrRequest(cidr)
    def cidr: GenericString
    def getCidr: ZIO[Any, Nothing, GenericString] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest
  ) extends zio.aws.globalaccelerator.model.AdvertiseByoipCidrRequest.ReadOnly {
    override val cidr: GenericString = impl.cidr(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest
  ): zio.aws.globalaccelerator.model.AdvertiseByoipCidrRequest.ReadOnly =
    new Wrapper(impl)
}
