package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeCustomRoutingAcceleratorRequest(
    acceleratorArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest = {
    import DescribeCustomRoutingAcceleratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest
      .builder()
      .acceleratorArn(GenericString.unwrap(acceleratorArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest
      .wrap(buildAwsValue())
}
object DescribeCustomRoutingAcceleratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest =
      zio.aws.globalaccelerator.model
        .DescribeCustomRoutingAcceleratorRequest(acceleratorArn)
    def acceleratorArn: GenericString
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest
  ) extends zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.acceleratorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest
  ): zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest.ReadOnly =
    new Wrapper(impl)
}
