package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingAcceleratorsResponse(
    accelerators: Option[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingAccelerator]
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse = {
    import ListCustomRoutingAcceleratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
      .builder()
      .optionallyWith(
        accelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accelerators)
      .optionallyWith(
        nextToken.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingAcceleratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse =
      zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse(
        accelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accelerators: Option[
      List[zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly]
    ]
    def nextToken: Option[GenericString]
    def getAccelerators: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ]] = AwsError.unwrapOptionField("accelerators", accelerators)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly {
    override val accelerators: Option[
      List[zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly]
    ] = scala
      .Option(impl.accelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingAccelerator.wrap(item)
        }.toList
      )
    override val nextToken: Option[GenericString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse.ReadOnly =
    new Wrapper(impl)
}
