package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorAttributesResponse(
    acceleratorAttributes: Option[
      zio.aws.globalaccelerator.model.AcceleratorAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse = {
    import DescribeAcceleratorAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse
      .builder()
      .optionallyWith(
        acceleratorAttributes.map(value => value.buildAwsValue())
      )(_.acceleratorAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeAcceleratorAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse =
      zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse(
        acceleratorAttributes.map(value => value.asEditable)
      )
    def acceleratorAttributes
        : Option[zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly]
    def getAcceleratorAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("acceleratorAttributes", acceleratorAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse
  ) extends zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly {
    override val acceleratorAttributes: Option[
      zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly
    ] = scala
      .Option(impl.acceleratorAttributes())
      .map(value =>
        zio.aws.globalaccelerator.model.AcceleratorAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse
  ): zio.aws.globalaccelerator.model.DescribeAcceleratorAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
