package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeleteAcceleratorRequest(acceleratorArn: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest = {
    import DeleteAcceleratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest
      .builder()
      .acceleratorArn(GenericString.unwrap(acceleratorArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeleteAcceleratorRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeleteAcceleratorRequest
      .wrap(buildAwsValue())
}
object DeleteAcceleratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DeleteAcceleratorRequest =
      zio.aws.globalaccelerator.model.DeleteAcceleratorRequest(acceleratorArn)
    def acceleratorArn: GenericString
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest
  ) extends zio.aws.globalaccelerator.model.DeleteAcceleratorRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.acceleratorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest
  ): zio.aws.globalaccelerator.model.DeleteAcceleratorRequest.ReadOnly =
    new Wrapper(impl)
}
