package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CidrAuthorizationContext(
    message: GenericString,
    signature: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CidrAuthorizationContext = {
    import CidrAuthorizationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CidrAuthorizationContext
      .builder()
      .message(GenericString.unwrap(message): java.lang.String)
      .signature(GenericString.unwrap(signature): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CidrAuthorizationContext.ReadOnly =
    zio.aws.globalaccelerator.model.CidrAuthorizationContext
      .wrap(buildAwsValue())
}
object CidrAuthorizationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CidrAuthorizationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CidrAuthorizationContext =
      zio.aws.globalaccelerator.model
        .CidrAuthorizationContext(message, signature)
    def message: GenericString
    def signature: GenericString
    def getMessage: ZIO[Any, Nothing, GenericString] = ZIO.succeed(message)
    def getSignature: ZIO[Any, Nothing, GenericString] = ZIO.succeed(signature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CidrAuthorizationContext
  ) extends zio.aws.globalaccelerator.model.CidrAuthorizationContext.ReadOnly {
    override val message: GenericString =
      zio.aws.globalaccelerator.model.primitives.GenericString(impl.message())
    override val signature: GenericString =
      zio.aws.globalaccelerator.model.primitives.GenericString(impl.signature())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CidrAuthorizationContext
  ): zio.aws.globalaccelerator.model.CidrAuthorizationContext.ReadOnly =
    new Wrapper(impl)
}
