package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ProvisionByoipCidrRequest(
    cidr: GenericString,
    cidrAuthorizationContext: zio.aws.globalaccelerator.model.CidrAuthorizationContext
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest = {
    import ProvisionByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest
      .builder()
      .cidr(GenericString.unwrap(cidr): java.lang.String)
      .cidrAuthorizationContext(cidrAuthorizationContext.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ProvisionByoipCidrRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ProvisionByoipCidrRequest
      .wrap(buildAwsValue())
}
object ProvisionByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ProvisionByoipCidrRequest =
      zio.aws.globalaccelerator.model
        .ProvisionByoipCidrRequest(cidr, cidrAuthorizationContext.asEditable)
    def cidr: GenericString
    def cidrAuthorizationContext
        : zio.aws.globalaccelerator.model.CidrAuthorizationContext.ReadOnly
    def getCidr: ZIO[Any, Nothing, GenericString] = ZIO.succeed(cidr)
    def getCidrAuthorizationContext: ZIO[
      Any,
      Nothing,
      zio.aws.globalaccelerator.model.CidrAuthorizationContext.ReadOnly
    ] = ZIO.succeed(cidrAuthorizationContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest
  ) extends zio.aws.globalaccelerator.model.ProvisionByoipCidrRequest.ReadOnly {
    override val cidr: GenericString =
      zio.aws.globalaccelerator.model.primitives.GenericString(impl.cidr())
    override val cidrAuthorizationContext
        : zio.aws.globalaccelerator.model.CidrAuthorizationContext.ReadOnly =
      zio.aws.globalaccelerator.model.CidrAuthorizationContext
        .wrap(impl.cidrAuthorizationContext())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest
  ): zio.aws.globalaccelerator.model.ProvisionByoipCidrRequest.ReadOnly =
    new Wrapper(impl)
}
