package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeleteCustomRoutingListenerRequest(
    listenerArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest = {
    import DeleteCustomRoutingListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest
      .builder()
      .listenerArn(GenericString.unwrap(listenerArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeleteCustomRoutingListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeleteCustomRoutingListenerRequest
      .wrap(buildAwsValue())
}
object DeleteCustomRoutingListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DeleteCustomRoutingListenerRequest =
      zio.aws.globalaccelerator.model
        .DeleteCustomRoutingListenerRequest(listenerArn)
    def listenerArn: GenericString
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest
  ) extends zio.aws.globalaccelerator.model.DeleteCustomRoutingListenerRequest.ReadOnly {
    override val listenerArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.listenerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest
  ): zio.aws.globalaccelerator.model.DeleteCustomRoutingListenerRequest.ReadOnly =
    new Wrapper(impl)
}
